/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.dev.tools.CommandLineTool;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SafeLinkedList
extends AbstractList
implements List,
Cloneable,
Serializable {
    protected Node m_head;
    protected Node m_tail;
    protected volatile int m_cNodes;
    protected transient int m_iPos;
    protected transient Node m_current;

    public SafeLinkedList() {
        this.reset();
    }

    public SafeLinkedList(Collection collection) {
        this.reset();
        this.addAll(collection);
    }

    @Override
    public int size() {
        return this.m_cNodes;
    }

    @Override
    public synchronized boolean add(Object o) {
        this.add(this.m_cNodes, o);
        return true;
    }

    @Override
    public synchronized boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    @Override
    public synchronized boolean contains(Object o) {
        for (Node node = this.m_head; node != null; node = node.getNext()) {
            if (!node.equalsValue(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        switch (collection.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.contains(collection.iterator().next());
            }
        }
        return super.containsAll(collection);
    }

    @Override
    public synchronized int indexOf(Object o) {
        Node node = this.m_head;
        int i = 0;
        while (node != null) {
            if (node.equalsValue(o)) {
                this.markPosition(i, node);
                return i;
            }
            node = node.getNext();
            ++i;
        }
        return -1;
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        Node node = this.m_tail;
        int i = this.m_cNodes - 1;
        while (node != null) {
            if (node.equalsValue(o)) {
                this.markPosition(i, node);
                return i;
            }
            node = node.getPrevious();
            --i;
        }
        return -1;
    }

    public synchronized void add(int i, Object o) {
        Node node = this.instantiateNode(o);
        int c = this.m_cNodes;
        if (i < c) {
            int iMark;
            node.linkBefore(this.getNode(i));
            if (i == 0) {
                this.m_head = node;
            }
            if (i <= (iMark = this.m_iPos)) {
                this.m_iPos = iMark + 1;
            }
        } else {
            if (i > c) {
                throw new IndexOutOfBoundsException("Index=" + i + ", Size=" + c);
            }
            if (c == 0) {
                this.m_head = node;
                this.m_tail = node;
            } else {
                node.linkAfter(this.m_tail);
                this.m_tail = node;
            }
        }
        this.m_cNodes = c + 1;
        ++this.modCount;
    }

    public synchronized Object remove(int i) {
        int c;
        Node node = this.getNode(i);
        Object oPrev = node.getObject();
        if ((c = --this.m_cNodes) == 0) {
            this.reset();
        } else {
            int iMark = this.m_iPos;
            if (i < iMark) {
                if (iMark == 1) {
                    this.markPosition(-1, null);
                } else {
                    this.m_iPos = iMark - 1;
                }
            } else if (iMark == c - 1) {
                this.markPosition(-1, null);
            } else if (iMark == i) {
                this.m_current = node.getNext();
            }
            if (node == this.m_head) {
                this.m_head = node.getNext();
            }
            if (node == this.m_tail) {
                this.m_tail = node.getPrevious();
            }
        }
        node.discard();
        ++this.modCount;
        return oPrev;
    }

    @Override
    public synchronized Object removeFirst() {
        return this.m_cNodes == 0 ? null : this.remove(0);
    }

    public synchronized Object get(int i) {
        return this.getNode(i).getObject();
    }

    @Override
    public synchronized Object getFirst() {
        return this.m_cNodes == 0 ? null : this.get(0);
    }

    public synchronized Object set(int i, Object o) {
        Node node = this.getNode(i);
        Object oPrev = node.getObject();
        node.setObject(o);
        return oPrev;
    }

    public synchronized boolean addAll(int i, Collection collection) {
        int c = this.m_cNodes;
        if (i < 0 || i > c) {
            throw new IndexOutOfBoundsException("Index=" + i + ", Size=" + c);
        }
        if (collection.isEmpty()) {
            return false;
        }
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(i++, iter.next());
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public synchronized void clear() {
        Node node = this.m_head;
        while (node != null) {
            Node next = node.getNext();
            node.discard();
            node = next;
        }
        this.reset();
        ++this.modCount;
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        int c = this.m_cNodes;
        if (a == null) {
            a = new Object[c];
        } else if (a.length < c) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
        } else if (a.length > c) {
            a[c] = null;
        }
        int i = 0;
        for (Node node = this.m_head; node != null; node = node.getNext()) {
            a[i++] = node.getObject();
        }
        return a;
    }

    public synchronized Object clone() {
        try {
            SafeLinkedList that = (SafeLinkedList)super.clone();
            Node thisHead = this.m_head;
            if (thisHead != null) {
                Node thatHead;
                Node thatTail = thatHead = (Node)thisHead.clone();
                Node thatNext = thatTail.m_nodeNext;
                while (thatNext != null) {
                    thatTail = thatNext;
                    thatNext = thatTail.m_nodeNext;
                }
                that.m_head = thatHead;
                that.m_tail = thatTail;
            }
            that.m_iPos = -1;
            that.m_current = null;
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Node node = this.m_head;
        int cNodes = this.m_cNodes;
        int cCheck = 0;
        out.writeInt(cNodes);
        while (node != null) {
            out.writeObject(node.getObject());
            node = node.getNext();
            ++cCheck;
        }
        if (cCheck != cNodes) {
            throw new IOException("expected to write " + cNodes + " objects but actually wrote " + cCheck);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.reset();
        int cNodes = in.readInt();
        Node nodePrev = null;
        for (int i = 0; i < cNodes; ++i) {
            Node nodeNext = this.instantiateNode(in.readObject());
            if (nodePrev == null) {
                this.m_head = nodeNext;
            } else {
                nodeNext.linkAfter(nodePrev);
            }
            nodePrev = nodeNext;
        }
        this.m_cNodes = cNodes;
        this.m_tail = nodePrev;
    }

    protected void markPosition(int i, Node node) {
        if (i > 0 && i < this.m_cNodes - 1) {
            this.m_iPos = i;
            this.m_current = node;
        } else {
            this.m_iPos = -1;
            this.m_current = null;
        }
    }

    protected void reset() {
        this.m_head = null;
        this.m_tail = null;
        this.m_cNodes = 0;
        this.m_iPos = -1;
        this.m_current = null;
    }

    protected Node instantiateNode(Object o) {
        return new Node(o);
    }

    protected Node getNode(int i) {
        Node node;
        int c = this.m_cNodes;
        if (i < 0 || i >= c) {
            throw new IndexOutOfBoundsException("Index=" + i + ", Size=" + c);
        }
        if (i == 0) {
            return this.m_head;
        }
        if (i == c - 1) {
            return this.m_tail;
        }
        int iMark = this.m_iPos;
        switch (i - iMark) {
            case -1: {
                Node node2 = this.m_current.getPrevious();
                this.markPosition(i, node2);
                return node2;
            }
            case 0: {
                return this.m_current;
            }
            case 1: {
                Node node3 = this.m_current.getNext();
                this.markPosition(i, node3);
                return node3;
            }
        }
        int iLeft = 0;
        Node left = this.m_head;
        int iRight = c - 1;
        Node right = this.m_tail;
        if (iMark > 0) {
            if (iMark < i) {
                iLeft = iMark;
                left = this.m_current;
            } else {
                iRight = iMark;
                right = this.m_current;
            }
        }
        if ((iLeft + iRight) / 2 > i) {
            node = left;
            for (int iNode = iLeft; iNode < i; ++iNode) {
                node = node.getNext();
            }
        } else {
            node = right;
            for (int iNode = iRight; iNode > i; --iNode) {
                node = node.getPrevious();
            }
        }
        this.markPosition(i, node);
        return node;
    }

    public static void main(String[] asArg) throws Exception {
        SafeLinkedList list = new SafeLinkedList();
        while (true) {
            try {
                while (true) {
                    String s;
                    if ((s = CommandLineTool.inputString("command>")) == null || s.length() == 0) {
                        Base.out(list);
                        Base.out();
                        continue;
                    }
                    String[] asParam = Base.parseDelimitedString(s, ' ');
                    String sCmd = asParam[0];
                    if (sCmd.equals("add")) {
                        list.add(asParam[1]);
                    } else if (sCmd.equals("get")) {
                        Base.out(list.get(Integer.parseInt(asParam[1])));
                    } else if (sCmd.equals("insert")) {
                        list.add(Integer.parseInt(asParam[1]), asParam[2]);
                    } else if (sCmd.equals("remove")) {
                        Base.out(list.remove(Integer.parseInt(asParam[1])));
                    }
                    Base.out("size=" + list.m_cNodes);
                    Base.out("mark=" + list.m_iPos);
                    Base.out("curr=" + list.m_current);
                    Base.out();
                }
            }
            catch (Exception e) {
                Base.err(e);
                continue;
            }
            break;
        }
    }

    protected static class Node
    extends Base
    implements Cloneable,
    Serializable {
        protected Object m_object;
        protected Node m_nodeNext;
        protected Node m_nodePrev;

        public Node() {
        }

        public Node(Object o) {
            this.m_object = o;
        }

        public Object getObject() {
            return this.m_object;
        }

        protected void setObject(Object o) {
            this.m_object = o;
        }

        public Node getNext() {
            return this.m_nodeNext;
        }

        public Node getPrevious() {
            return this.m_nodePrev;
        }

        protected void linkBefore(Node next) {
            Node prev = next.m_nodePrev;
            if (prev != null) {
                prev.m_nodeNext = this;
            }
            next.m_nodePrev = this;
            this.m_nodePrev = prev;
            this.m_nodeNext = next;
        }

        protected void linkAfter(Node prev) {
            Node next = prev.m_nodeNext;
            prev.m_nodeNext = this;
            if (next != null) {
                next.m_nodePrev = this;
            }
            this.m_nodePrev = prev;
            this.m_nodeNext = next;
        }

        protected void delink() {
            Node prev = this.m_nodePrev;
            Node next = this.m_nodeNext;
            if (prev != null) {
                prev.m_nodeNext = next;
            }
            if (next != null) {
                next.m_nodePrev = prev;
            }
            this.m_nodeNext = null;
            this.m_nodePrev = null;
        }

        protected Object discard() {
            this.delink();
            Object o = this.m_object;
            this.m_object = null;
            return o;
        }

        public boolean equals(Object that) {
            if (that instanceof Node) {
                return this.equalsValue(((Node)that).m_object);
            }
            return false;
        }

        public boolean equalsValue(Object oThat) {
            Object oThis = this.m_object;
            return oThis == null ? oThat == null : oThis.equals(oThat);
        }

        public String toString() {
            return String.valueOf(this.m_object);
        }

        public Object clone() {
            try {
                Node that = (Node)super.clone();
                Node thisNext = this.m_nodeNext;
                if (thisNext != null) {
                    Node thatNext = (Node)thisNext.clone();
                    thatNext.m_nodePrev = that;
                    that.m_nodeNext = thatNext;
                }
                that.m_nodePrev = null;
                return that;
            }
            catch (CloneNotSupportedException e) {
                throw Node.ensureRuntimeException(e);
            }
        }
    }
}

