/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.util.AutoLock;
import com.tangosol.util.AbstractSafeLongArray;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import java.util.concurrent.locks.ReentrantLock;

public class SafeLongArray<V>
extends AbstractSafeLongArray<V> {
    protected final AutoLock<LongArray<V>> f_lock;

    public SafeLongArray() {
        this(new SparseArray());
    }

    public SafeLongArray(LongArray<V> laDelegate) {
        this.f_lock = new AutoLock<LongArray<V>>(new ReentrantLock(), laDelegate);
    }

    public AutoLock<LongArray<V>> getLock() {
        return this.f_lock;
    }

    @Override
    public SafeLongArray<V> clone() {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            SafeLongArray<V> safeLongArray = new SafeLongArray<V>(sentry.getResource().clone());
            return safeLongArray;
        }
    }

    @Override
    protected AutoLock.Sentry<LongArray<V>> acquireReadLock() {
        return this.f_lock.acquire();
    }

    @Override
    protected AutoLock.Sentry<LongArray<V>> acquireWriteLock() {
        return this.f_lock.acquire();
    }
}

