/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Listeners;
import com.tangosol.util.Service;
import com.tangosol.util.ServiceListener;
import java.util.EventListener;
import java.util.EventObject;

public class ServiceEvent
extends EventObject {
    public static final int SERVICE_STARTING = 1;
    public static final int SERVICE_STARTED = 2;
    public static final int SERVICE_STOPPING = 3;
    public static final int SERVICE_STOPPED = 4;
    private static final String[] DESCRIPTIONS = new String[]{"<unknown>", "STARTING", "STARTED", "STOPPING", "STOPPED"};
    private int m_nId;

    public ServiceEvent(Service service, int nId) {
        super(service);
        this.m_nId = nId;
    }

    public int getId() {
        return this.m_nId;
    }

    public Service getService() {
        return (Service)this.getSource();
    }

    @Override
    public String toString() {
        return new StringBuffer("ServiceEvent{").append(DESCRIPTIONS[this.getId()]).append(' ').append(this.getSource().getClass().getName()).append('}').toString();
    }

    public void dispatch(Listeners listeners) {
        if (listeners != null) {
            this.dispatch(listeners.listeners());
        }
    }

    public void dispatch(EventListener[] aListeners) {
        int i = aListeners.length;
        while (--i >= 0) {
            ServiceListener target = (ServiceListener)aListeners[i];
            switch (this.getId()) {
                case 1: {
                    target.serviceStarting(this);
                    break;
                }
                case 2: {
                    target.serviceStarted(this);
                    break;
                }
                case 3: {
                    target.serviceStopping(this);
                    break;
                }
                case 4: {
                    target.serviceStopped(this);
                }
            }
        }
    }
}

