/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.QueryRecord;
import com.tangosol.util.aggregator.QueryRecorder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SimpleQueryRecordReporter {
    private static final int FOOTER_LINE_WIDTH = 79;
    private static final int EXPLAIN_NAME_WIDTH = 65;
    private static final int TRACE_NAME_WIDTH = 41;
    private static final int INDEX_DESCR_WIDTH = 37;
    private static final int INDEX_EXTRACTOR_WIDTH = 31;
    private static final String DIVIDER = "======================================================================================%n";
    private static final String REPORT_NA = "----";
    private static final String NO_INDEX = "No index found";
    private static final String PARTITION_FORMAT = "%s%n%n";
    private static final String TRACE_HEADER_FORMAT = "%nTrace%n%-41.41s   %-5.5s   %-20.20s   %-10.10s%n";
    private static final String TRACE_STEP_FORMAT = "%-41.41s | %-5.5s | %-20.20s | %-10.10s";
    private static final String EXPLAIN_HEADER_FORMAT = "%nExplain Plan%n%-65.65s   %-5.5s   %-10.10s%n";
    private static final String EXPLAIN_STEP_FORMAT = "%-65.65s | %-5.5s | %-10.10s";
    private static final String INDEX_HEADER_FORMAT = "%nIndex Lookups%n%-5.5s %-37.37s   %-31.31s  %-7.7s%n";
    private static final String INDEX_LOOKUP_FORMAT = "%-4.4s| %-37.37s | %-31.31s | %-6.6s%n";
    private static final String FOOTER_HEADER_FORMAT = "%nComplete filter and index descriptions%n%-1.1s     %s%n";
    private static final String FOOTER_LEAD_FORMAT = "%-4.4s| %s%n";
    private static final String FOOTER_NEXT_LINE_FORMAT = "    | %s%n";

    public static String report(QueryRecord record) {
        StringBuilder sb = new StringBuilder();
        LinkedList<QueryRecord.PartialResult.IndexLookupRecord> listIndexLookups = new LinkedList<QueryRecord.PartialResult.IndexLookupRecord>();
        List<? extends QueryRecord.PartialResult> listRecords = record.getResults();
        boolean fReportPartition = listRecords.size() > 1;
        ArrayList<String> listFooter = new ArrayList<String>();
        for (QueryRecord.PartialResult partialResult : listRecords) {
            sb.append(SimpleQueryRecordReporter.reportResult(partialResult, record.getType(), listIndexLookups, fReportPartition, listFooter));
        }
        sb.append(SimpleQueryRecordReporter.reportIndexLookUps(listIndexLookups, listFooter));
        sb.append(SimpleQueryRecordReporter.reportFooter(listFooter));
        return sb.toString();
    }

    protected static String reportResult(QueryRecord.PartialResult result, QueryRecorder.RecordType type, List<QueryRecord.PartialResult.IndexLookupRecord> listIndexLookups, boolean fReportPartition, List<String> listFooter) {
        StringBuilder sb = new StringBuilder();
        if (type == QueryRecorder.RecordType.TRACE) {
            sb.append(String.format(TRACE_HEADER_FORMAT, "Filter Name", "Index", "Effectiveness", "Duration"));
        } else {
            sb.append(String.format(EXPLAIN_HEADER_FORMAT, "Filter Name", "Index", "Cost"));
        }
        sb.append(String.format(DIVIDER, new Object[0]));
        for (QueryRecord.PartialResult.Step step : result.getSteps()) {
            sb.append(SimpleQueryRecordReporter.reportStep(step, type, listIndexLookups, 0, listFooter));
            sb.append(String.format("%n", new Object[0]));
        }
        sb.append(String.format("%n", new Object[0]));
        if (fReportPartition) {
            sb.append(String.format(PARTITION_FORMAT, result.getPartitions().toString()));
        }
        return sb.toString();
    }

    protected static String reportIndexLookUps(List<QueryRecord.PartialResult.IndexLookupRecord> listIndexLookups, List<String> listFooter) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(INDEX_HEADER_FORMAT, "Index", "Description", "Extractor", "Ordered"));
        sb.append(String.format(DIVIDER, new Object[0]));
        for (int i = 0; i < listIndexLookups.size(); ++i) {
            sb.append(SimpleQueryRecordReporter.reportIndexLookupRecord(i, listIndexLookups.get(i), listFooter));
        }
        sb.append(String.format("%n", new Object[0]));
        return sb.toString();
    }

    protected static String reportFooter(List<String> listFooter) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(FOOTER_HEADER_FORMAT, "N", "Full Name"));
        sb.append(String.format(DIVIDER, new Object[0]));
        for (int i = 0; i < listFooter.size(); ++i) {
            sb.append(SimpleQueryRecordReporter.reportFooterItem(i, listFooter.get(i)));
        }
        return sb.toString();
    }

    protected static String reportStep(QueryRecord.PartialResult.Step step, QueryRecorder.RecordType type, List<QueryRecord.PartialResult.IndexLookupRecord> listIndexLookups, int nLevel, List<String> listFooter) {
        StringBuilder sbName = new StringBuilder();
        for (int i = 0; i < nLevel; ++i) {
            sbName.append("  ");
        }
        sbName.append(step.getFilterDescription());
        SimpleQueryRecordReporter.checkTruncation(listFooter, sbName, type == QueryRecorder.RecordType.EXPLAIN ? 65 : 41);
        String sCost = step.getEfficiency() >= 0 ? Integer.toString(step.getEfficiency()) : REPORT_NA;
        String sSizeIn = step.getPreFilterKeySetSize() >= 0 ? Integer.toString(step.getPreFilterKeySetSize()) : REPORT_NA;
        String sSizeOut = step.getPostFilterKeySetSize() >= 0 ? Integer.toString(step.getPostFilterKeySetSize()) : REPORT_NA;
        String sDuration = step.getDuration() >= 0L ? Long.toString(step.getDuration()) : REPORT_NA;
        StringBuilder sbIndex = new StringBuilder();
        for (QueryRecord.PartialResult.IndexLookupRecord indexLookupRecord : step.getIndexLookupRecords()) {
            int n = listIndexLookups.indexOf(indexLookupRecord);
            if (n == -1) {
                n = listIndexLookups.size();
                listIndexLookups.add(indexLookupRecord);
            }
            sbIndex.append(sbIndex.length() > 0 ? "," : "" + n);
        }
        StringBuilder sbStep = new StringBuilder();
        if (type == QueryRecorder.RecordType.TRACE) {
            int n = step.getPreFilterKeySetSize() == 0 ? 0 : (step.getPreFilterKeySetSize() - step.getPostFilterKeySetSize()) * 100 / step.getPreFilterKeySetSize();
            String string = sSizeIn + "|" + sSizeOut + "(" + n + "%)";
            sbStep.append(String.format(TRACE_STEP_FORMAT, sbName, sbIndex.length() > 0 ? sbIndex : REPORT_NA, string, sDuration));
        } else {
            sbStep.append(String.format(EXPLAIN_STEP_FORMAT, sbName, sbIndex.length() > 0 ? sbIndex : REPORT_NA, sCost));
        }
        for (QueryRecord.PartialResult.Step step2 : step.getSteps()) {
            sbStep.append(String.format("%n", new Object[0])).append(SimpleQueryRecordReporter.reportStep(step2, type, listIndexLookups, nLevel + 1, listFooter));
        }
        return sbStep.toString();
    }

    protected static void checkTruncation(List<String> listFooter, StringBuilder sbName, int nColumnWidth) {
        if (sbName.length() > nColumnWidth) {
            String sFLine = sbName.toString().replaceAll("^\\s+", "");
            int nInd = listFooter.indexOf(sFLine);
            if (nInd == -1) {
                nInd = listFooter.size();
                listFooter.add(sFLine);
            }
            String sRef = "... (" + nInd + ")";
            sbName.replace(nColumnWidth - sRef.length(), nColumnWidth, sRef);
        }
    }

    protected static String reportIndexLookupRecord(int nIndexLookupId, QueryRecord.PartialResult.IndexLookupRecord record, List<String> listFooter) {
        String sDesc = record.getIndexDescription();
        StringBuilder sbIndexDesc = new StringBuilder(sDesc == null ? NO_INDEX : sDesc);
        String sExtr = record.getExtractorDescription();
        StringBuilder sbIndexExtr = new StringBuilder(sExtr == null ? REPORT_NA : sExtr);
        SimpleQueryRecordReporter.checkTruncation(listFooter, sbIndexDesc, 37);
        SimpleQueryRecordReporter.checkTruncation(listFooter, sbIndexExtr, 31);
        return String.format(INDEX_LOOKUP_FORMAT, Integer.toString(nIndexLookupId), sbIndexDesc.toString(), sbIndexExtr.toString(), record.isOrdered());
    }

    protected static String reportFooterItem(int n, String sItem) {
        int cLen = sItem.length();
        int cLines = cLen / 79;
        StringBuilder sbLine = new StringBuilder(String.format(FOOTER_LEAD_FORMAT, Integer.toString(n), sItem.substring(0, Math.min(cLen, 79))));
        for (int l = 1; l < cLines; ++l) {
            sbLine.append(String.format(FOOTER_NEXT_LINE_FORMAT, sItem.substring(l * 79, (l + 1) * 79)));
        }
        if (cLines > 0 && cLen % 79 > 0) {
            sbLine.append(String.format(FOOTER_NEXT_LINE_FORMAT, sItem.substring(cLines * 79)));
        }
        return sbLine.append("\n").toString();
    }
}

