/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Gate;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperObservableMap;
import com.tangosol.util.WrapperReentrantGate;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class WrapperConcurrentMap<K, V>
extends WrapperObservableMap<K, V>
implements ConcurrentMap<K, V> {
    protected boolean m_fEnforceLocking;
    protected long m_cWaitMillis;
    protected final SafeHashMap m_mapLock = new SafeHashMap();
    protected final Gate m_gateMap = new WrapperReentrantGate();

    public WrapperConcurrentMap(Map<K, V> map) {
        this(map, true, -1L);
    }

    public WrapperConcurrentMap(Map<K, V> map, boolean fEnforceLocking, long cWaitMillis) {
        super(map);
        this.m_fEnforceLocking = fEnforceLocking;
        this.m_cWaitMillis = cWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean lock(Object oKey, long cWait) {
        boolean bl;
        Object object;
        Map map = this.getMap();
        if (map instanceof ConcurrentMap) {
            return ((ConcurrentMap)map).lock(oKey, cWait);
        }
        SafeHashMap mapLock = this.m_mapLock;
        Gate gateMap = this.m_gateMap;
        if (oKey == LOCK_ALL) {
            return gateMap.close(cWait);
        }
        if (!gateMap.enter(cWait)) {
            return false;
        }
        boolean fSuccess = false;
        Lock lock = null;
        while (true) {
            object = mapLock;
            // MONITORENTER : object
            lock = (Lock)mapLock.get(oKey);
            if (lock != null) break block18;
            lock = this.instantiateLock(oKey);
            lock.assign(0L);
            mapLock.put(oKey, lock);
            fSuccess = true;
            bl = true;
            // MONITOREXIT : object
            if (fSuccess) return bl;
            if (lock == null || !lock.isDiscardable()) break block19;
            mapLock.remove(oKey);
            break;
        }
        catch (Throwable throwable) {
            if (fSuccess) throw throwable;
            if (lock != null && lock.isDiscardable()) {
                mapLock.remove(oKey);
            }
            gateMap.exit();
            throw throwable;
        }
        {
            block20: {
                boolean bl2;
                block21: {
                    block18: {
                        block19: {
                        }
                        gateMap.exit();
                        return bl;
                    }
                    if (lock.isOwnedByCaller()) {
                        lock.assign(0L);
                        fSuccess = true;
                        boolean bl3 = true;
                        // MONITOREXIT : object
                        if (fSuccess) return bl3;
                        if (lock != null && lock.isDiscardable()) {
                            mapLock.remove(oKey);
                        }
                        gateMap.exit();
                        return bl3;
                    }
                    // MONITOREXIT : object
                    object = lock;
                    // MONITORENTER : object
                    if (lock != mapLock.get(oKey)) break block20;
                    bl2 = fSuccess = lock.assign(cWait);
                    // MONITOREXIT : object
                    if (fSuccess) return bl2;
                    if (lock == null || !lock.isDiscardable()) break block21;
                    mapLock.remove(oKey);
                }
                gateMap.exit();
                return bl2;
            }
            // MONITOREXIT : object
            continue;
        }
    }

    @Override
    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(Object oKey) {
        Lock lock;
        Map map = this.getMap();
        if (map instanceof ConcurrentMap) {
            return ((ConcurrentMap)map).unlock(oKey);
        }
        SafeHashMap mapLock = this.m_mapLock;
        Gate gateMap = this.m_gateMap;
        if (oKey == LOCK_ALL) {
            try {
                gateMap.open();
                return true;
            }
            catch (IllegalMonitorStateException e) {
                return false;
            }
        }
        boolean fReleased = true;
        boolean fExitGate = false;
        while ((lock = (Lock)mapLock.get(oKey)) != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                if (mapLock.get(oKey) == lock) {
                    fExitGate = !lock.isDirty();
                    fReleased = lock.release();
                    if (lock.isDiscardable()) {
                        mapLock.remove(oKey);
                    }
                    break;
                }
            }
        }
        if (fExitGate) {
            try {
                gateMap.exit();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return fReleased;
    }

    @Override
    public void clear() {
        boolean fForceLock = this.isLockingEnforced();
        if (!fForceLock || this.lock(LOCK_ALL, this.getWaitMillis())) {
            try {
                super.clear();
            }
            finally {
                if (fForceLock) {
                    this.unlock(LOCK_ALL);
                }
            }
        } else {
            throw new ConcurrentModificationException("clear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K oKey, V oValue) {
        boolean fForceLock = this.isLockingEnforced();
        if (!fForceLock || this.lock(oKey, this.getWaitMillis())) {
            try {
                V v = super.put(oKey, oValue);
                return v;
            }
            finally {
                if (fForceLock) {
                    this.unlock(oKey);
                }
            }
        }
        throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        block7: {
            block6: {
                Iterator<Object> iter;
                boolean fForceLock = this.isLockingEnforced();
                if (!fForceLock) break block6;
                HashSet<K> setLocked = new HashSet<K>();
                try {
                    for (K oKey : map.keySet()) {
                        if (this.lock(oKey, this.getWaitMillis())) {
                            setLocked.add(oKey);
                            continue;
                        }
                        throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
                    }
                    super.putAll(map);
                    iter = setLocked.iterator();
                }
                catch (Throwable throwable) {
                    Iterator iter2 = setLocked.iterator();
                    while (iter2.hasNext()) {
                        this.unlock(iter2.next());
                    }
                    throw throwable;
                }
                while (iter.hasNext()) {
                    this.unlock(iter.next());
                }
                break block7;
            }
            super.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object oKey) {
        boolean fForceLock = this.isLockingEnforced();
        if (!fForceLock || this.lock(oKey, this.getWaitMillis())) {
            try {
                Object v = super.remove(oKey);
                return v;
            }
            finally {
                if (fForceLock) {
                    this.unlock(oKey);
                }
            }
        }
        throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
    }

    @Override
    protected boolean isInternalKeySetIteratorMutable() {
        return super.isInternalKeySetIteratorMutable() && !this.isLockingEnforced();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeBlind(Object oKey) {
        boolean fForceLock = this.isLockingEnforced();
        if (!fForceLock || this.lock(oKey, this.getWaitMillis())) {
            try {
                boolean bl = super.removeBlind(oKey);
                return bl;
            }
            finally {
                if (fForceLock) {
                    this.unlock(oKey);
                }
            }
        }
        throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
    }

    @Override
    public String toString() {
        return "WrapperConcurrentMap {" + this.getDescription() + "}";
    }

    public boolean isLockingEnforced() {
        return this.m_fEnforceLocking;
    }

    public void setLockingEnforced(boolean fEnforce) {
        this.m_fEnforceLocking = fEnforce;
    }

    public long getWaitMillis() {
        return this.m_cWaitMillis;
    }

    public void setWaitMillis(long cWaitMillis) {
        this.m_cWaitMillis = cWaitMillis;
    }

    @Override
    protected String getDescription() {
        return super.getDescription() + ", LockingEnforced=" + this.isLockingEnforced() + ", WaitMillis=" + this.getWaitMillis() + ", ThreadGate=" + this.m_gateMap + ", Locks={" + this.m_mapLock + "}";
    }

    public String getLockDescription(Object oKey) {
        return "key=\"" + oKey + "\", lock=" + this.m_mapLock.get(oKey);
    }

    protected Lock instantiateLock(Object oKey) {
        return new Lock();
    }

    protected static class Lock
    extends Base {
        private Thread m_thread;
        private short m_cLock;
        private short m_cBlock;

        protected Lock() {
        }

        protected boolean assign(long cWait) {
            while (this.isDirty()) {
                if (cWait == 0L) {
                    return false;
                }
                cWait = this.waitForNotify(cWait);
            }
            int cLock = this.m_cLock + 1;
            if (cLock == 1) {
                this.m_thread = Thread.currentThread();
            } else if (cLock == Short.MAX_VALUE) {
                throw new RuntimeException("Lock count overflow: " + this);
            }
            this.m_cLock = (short)cLock;
            return true;
        }

        protected long waitForNotify(long cWait) {
            long lTime = Lock.getSafeTimeMillis();
            try {
                this.m_cBlock = (short)(this.m_cBlock + 1);
                long cMaxWait = 1000L;
                long cMillis = cWait <= 0L || cWait > 1000L ? 1000L : cWait;
                Blocking.wait(this, cMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Lock.ensureRuntimeException(e, "Lock request interrupted");
            }
            finally {
                this.m_cBlock = (short)(this.m_cBlock - 1);
            }
            if (cWait > 0L) {
                cWait -= Lock.getSafeTimeMillis() - lTime;
                cWait = Math.max(0L, cWait);
            }
            return cWait;
        }

        protected boolean release() {
            if (this.isDirty()) {
                return false;
            }
            int cLock = this.m_cLock - 1;
            if (cLock == 0) {
                this.m_thread = null;
            } else if (cLock < 0) {
                cLock = 0;
            }
            this.m_cLock = (short)cLock;
            if (cLock == 0) {
                if (this.m_cBlock > 0) {
                    this.notify();
                }
                return true;
            }
            return false;
        }

        protected boolean isDirty() {
            Thread threadHolder = this.m_thread;
            Thread threadCurrent = Thread.currentThread();
            if (threadHolder != null && threadHolder != threadCurrent) {
                if (threadHolder.isAlive()) {
                    return true;
                }
                this.m_thread = null;
                this.m_cLock = 0;
                if (this.m_cBlock > 0) {
                    this.notify();
                }
            }
            return false;
        }

        protected boolean isOwnedByCaller() {
            return this.m_thread == Thread.currentThread();
        }

        protected boolean isDiscardable() {
            return this.m_cLock == 0 && this.m_cBlock == 0;
        }

        protected Thread getLockThread() {
            return this.m_thread;
        }

        protected int getLockCount() {
            return this.m_cLock;
        }

        protected int getBlockCount() {
            return this.m_cBlock;
        }

        protected String getLockTypeDescription() {
            return "Lock";
        }

        public String toString() {
            return this.getLockTypeDescription() + "[" + this.m_thread + ", cnt=" + this.m_cLock + ", block=" + this.m_cBlock + ']';
        }
    }
}

