/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.internal.util.aggregator.BigDecimalSerializationWrapper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.AbstractBigDecimalAggregator;
import java.math.BigDecimal;

public class BigDecimalAverage<T>
extends AbstractBigDecimalAggregator<T> {
    public BigDecimalAverage() {
    }

    public BigDecimalAverage(ValueExtractor<? super T, ? extends Number> extractor) {
        super(extractor);
    }

    public BigDecimalAverage(String sMethod) {
        super(sMethod);
    }

    @Override
    public InvocableMap.StreamingAggregator<Object, Object, Object, BigDecimal> supply() {
        return new BigDecimalAverage(this.getValueExtractor());
    }

    @Override
    public int characteristics() {
        return 33;
    }

    @Override
    protected void process(Object o, boolean fFinal) {
        if (o != null) {
            BigDecimal decResult = this.m_decResult;
            if (fFinal) {
                BigDecimalSerializationWrapper wrapper = (BigDecimalSerializationWrapper)o;
                int c = wrapper.getCount();
                if (c > 0) {
                    this.m_count += c;
                    BigDecimal partialResult = wrapper.getBigDecimal();
                    this.m_decResult = decResult == null ? partialResult : decResult.add(partialResult);
                }
            } else {
                BigDecimal dec = BigDecimalAverage.ensureBigDecimal((Number)o);
                ++this.m_count;
                this.m_decResult = decResult == null ? dec : decResult.add(dec);
            }
        }
    }

    @Override
    protected Object finalizeResult(boolean fFinal) {
        int c = this.m_count;
        BigDecimal decResult = this.m_decResult;
        if (fFinal) {
            return c == 0 ? null : decResult.divide(BigDecimal.valueOf(c), decResult.scale() + 8, 4);
        }
        return c > 0 ? new BigDecimalSerializationWrapper(this.m_count, this.m_decResult) : null;
    }
}

