/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import javax.json.bind.annotation.JsonbProperty;

public class GroupAggregator<K, V, T, E, R>
extends ExternalizableHelper
implements InvocableMap.StreamingAggregator<K, V, Map<E, Object>, Map<E, R>>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="extractor")
    protected ValueExtractor<? super T, ? extends E> m_extractor;
    @JsonbProperty(value="aggregator")
    protected InvocableMap.EntryAggregator<? super K, ? super V, R> m_aggregator;
    @JsonbProperty(value="filter")
    protected Filter m_filter;
    protected transient boolean m_fInit;
    protected transient boolean m_fStreaming;
    protected transient boolean m_fParallel;
    protected transient Map<E, Object> m_mapResults;

    public GroupAggregator() {
    }

    protected GroupAggregator(ValueExtractor<? super T, ? extends E> extractor, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator, Filter filter) {
        GroupAggregator.azzert(extractor != null && aggregator != null);
        this.m_extractor = extractor;
        this.m_aggregator = aggregator;
        this.m_filter = filter;
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, Map<E, Object>, Map<E, R>> supply() {
        return new GroupAggregator<K, V, T, E, R>(this.m_extractor, this.m_aggregator, this.m_filter);
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        this.ensureInitialized();
        if (entry.isPresent()) {
            E groupKey = entry.extract(this.m_extractor);
            if (this.isDelegateStreaming()) {
                InvocableMap.StreamingAggregator aggregator = (InvocableMap.StreamingAggregator)this.m_mapResults.computeIfAbsent(groupKey, k -> this.streaming(this.m_aggregator).supply());
                aggregator.accumulate(entry);
            } else {
                Set setEntries = (Set)this.m_mapResults.computeIfAbsent(groupKey, k -> new HashSet());
                setEntries.add(entry);
            }
        }
        return true;
    }

    @Override
    public boolean combine(Map<E, Object> partialResult) {
        this.ensureInitialized();
        for (Map.Entry<E, Object> part : partialResult.entrySet()) {
            E groupKey = part.getKey();
            if (this.isDelegateStreaming()) {
                InvocableMap.StreamingAggregator aggregator = (InvocableMap.StreamingAggregator)this.m_mapResults.computeIfAbsent(groupKey, k -> this.streaming(this.m_aggregator).supply());
                aggregator.combine(part.getValue());
                continue;
            }
            if (this.isDelegateParallel()) {
                List listResults = (List)this.m_mapResults.computeIfAbsent(groupKey, k -> new ArrayList());
                listResults.add(part.getValue());
                continue;
            }
            Set setEntries = (Set)this.m_mapResults.computeIfAbsent(groupKey, k -> new HashSet());
            setEntries.addAll((Collection)part.getValue());
        }
        return true;
    }

    @Override
    public Map<E, Object> getPartialResult() {
        this.ensureInitialized();
        boolean fStreaming = this.isDelegateStreaming();
        if (!fStreaming && !this.isDelegateParallel()) {
            return this.m_mapResults;
        }
        LiteMap mapResults = new LiteMap();
        for (Map.Entry<E, Object> entry : this.m_mapResults.entrySet()) {
            Object oResult = fStreaming ? ((InvocableMap.StreamingAggregator)entry.getValue()).getPartialResult() : this.parallel(this.m_aggregator).getParallelAggregator().aggregate((Set)entry.getValue());
            mapResults.put(entry.getKey(), oResult);
        }
        return mapResults;
    }

    @Override
    public Map<E, R> finalizeResult() {
        this.ensureInitialized();
        boolean fStreaming = this.isDelegateStreaming();
        boolean fParallelAware = this.isDelegateParallel();
        Filter filter = this.m_filter;
        LiteMap mapResults = new LiteMap();
        for (Map.Entry<E, Object> entry : this.m_mapResults.entrySet()) {
            Object result;
            Object r = fStreaming ? ((InvocableMap.StreamingAggregator)entry.getValue()).finalizeResult() : (result = fParallelAware ? this.parallel(this.m_aggregator).aggregateResults((Collection)entry.getValue()) : this.m_aggregator.aggregate((Set)entry.getValue()));
            if (filter != null && !filter.evaluate(result)) continue;
            mapResults.put(entry.getKey(), result);
        }
        return mapResults;
    }

    @Override
    public int characteristics() {
        this.ensureInitialized();
        return this.isDelegateStreaming() ? this.streaming(this.m_aggregator).characteristics() : 17;
    }

    public ValueExtractor<?, ? extends E> getExtractor() {
        return this.m_extractor;
    }

    public InvocableMap.EntryAggregator<? super K, ? super V, R> getAggregator() {
        return this.m_aggregator;
    }

    protected void ensureInitialized() {
        if (!this.m_fInit) {
            this.m_mapResults = new LiteMap<E, Object>();
            this.m_fStreaming = this.m_aggregator instanceof InvocableMap.StreamingAggregator;
            if (!this.m_fStreaming) {
                this.m_fParallel = this.m_aggregator instanceof InvocableMap.ParallelAwareAggregator;
            }
            this.m_fInit = true;
        }
    }

    protected InvocableMap.StreamingAggregator<? super K, ? super V, Object, R> streaming(InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return (InvocableMap.StreamingAggregator)aggregator;
    }

    protected InvocableMap.ParallelAwareAggregator<? super K, ? super V, Object, R> parallel(InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return (InvocableMap.ParallelAwareAggregator)aggregator;
    }

    protected boolean isDelegateStreaming() {
        return this.m_fStreaming;
    }

    protected boolean isDelegateParallel() {
        return this.m_fParallel;
    }

    protected static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException("Duplicate group key");
        };
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)GroupAggregator.readObject(in);
        this.m_aggregator = (InvocableMap.EntryAggregator)GroupAggregator.readObject(in);
        this.m_filter = (Filter)GroupAggregator.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        GroupAggregator.writeObject(out, this.m_extractor);
        GroupAggregator.writeObject(out, this.m_aggregator);
        GroupAggregator.writeObject(out, this.m_filter);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_aggregator = (InvocableMap.EntryAggregator)in.readObject(1);
        this.m_filter = (Filter)in.readObject(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeObject(1, this.m_aggregator);
        out.writeObject(2, this.m_filter);
    }

    public boolean equals(Object o) {
        if (o instanceof GroupAggregator) {
            GroupAggregator that = (GroupAggregator)o;
            return GroupAggregator.equals(this.m_extractor, that.m_extractor) && GroupAggregator.equals(this.m_aggregator, that.m_aggregator);
        }
        return false;
    }

    public int hashCode() {
        return this.m_extractor.hashCode() + this.m_aggregator.hashCode();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '(' + this.m_extractor + ", " + this.m_aggregator + (this.m_filter == null ? "" : ", " + this.m_filter) + ')';
    }

    public static <K, V, R> GroupAggregator<K, V, Object, Object, R> createInstance(String sMethod, InvocableMap.EntryAggregator<K, V, R> aggregator) {
        return GroupAggregator.createInstance(sMethod, aggregator, null);
    }

    public static <K, V, R> GroupAggregator<K, V, Object, Object, R> createInstance(String sMethod, InvocableMap.EntryAggregator<K, V, R> aggregator, Filter filter) {
        MultiExtractor extractor = sMethod.indexOf(44) >= 0 ? new MultiExtractor(sMethod) : (sMethod.indexOf(46) >= 0 ? new ChainedExtractor(sMethod) : new ReflectionExtractor(sMethod));
        return GroupAggregator.createInstance(extractor, aggregator, filter);
    }

    public static <K, V, T, E, R> GroupAggregator<K, V, T, E, R> createInstance(ValueExtractor<? super T, ? extends E> extractor, InvocableMap.EntryAggregator<K, V, R> aggregator) {
        return GroupAggregator.createInstance(extractor, aggregator, null);
    }

    public static <K, V, T, E, R> GroupAggregator<K, V, T, E, R> createInstance(ValueExtractor<? super T, ? extends E> extractor, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator, Filter filter) {
        return new GroupAggregator<K, V, T, E, R>(extractor, aggregator, filter);
    }

    @Deprecated
    public static class Parallel<K, V, T, E, R>
    extends GroupAggregator<K, V, T, E, R> {
        public Parallel() {
        }

        protected Parallel(ValueExtractor<? super T, ? extends E> extractor, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator, Filter<?> filter) {
            super(extractor, aggregator, filter);
        }
    }
}

