/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.internal.util.graal.ScriptManager;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.AbstractScript;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectStreamException;

public class ScriptAggregator<K, V, P, R>
extends AbstractScript
implements InvocableMap.StreamingAggregator<K, V, P, R>,
SerializationSupport {
    private int m_nCharacteristics;
    private transient InvocableMap.StreamingAggregator<K, V, P, R> m_delegate;

    public ScriptAggregator() {
    }

    public ScriptAggregator(String language, String name, int characteristics, Object ... args) {
        super(language, name, args);
        this.m_nCharacteristics = characteristics;
    }

    private ScriptAggregator(InvocableMap.StreamingAggregator<K, V, P, R> delegate, int characteristics) {
        this.m_delegate = delegate;
        this.m_nCharacteristics = characteristics;
    }

    @Override
    public int characteristics() {
        return this.m_nCharacteristics == 0 ? InvocableMap.StreamingAggregator.super.characteristics() : this.m_nCharacteristics;
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, P, R> supply() {
        return new ScriptAggregator<K, V, P, R>(this.createDelegate(), this.m_nCharacteristics);
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        return this.m_delegate.accumulate(entry);
    }

    @Override
    public boolean combine(P partialResult) {
        return this.m_delegate.combine(partialResult);
    }

    @Override
    public P getPartialResult() {
        return this.m_delegate.getPartialResult();
    }

    @Override
    public R finalizeResult() {
        return this.m_delegate.finalizeResult();
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_nCharacteristics = in.readInt(10);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeInt(10, this.m_nCharacteristics);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_nCharacteristics = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.m_nCharacteristics);
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        this.m_delegate = this.createDelegate();
        return this;
    }

    private InvocableMap.StreamingAggregator<K, V, P, R> createDelegate() {
        return (InvocableMap.StreamingAggregator)ScriptManager.getInstance().execute(this.m_sLanguage, this.m_sName, this.m_aoArgs).as(InvocableMap.StreamingAggregator.class);
    }
}

