/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.json.bind.annotation.JsonbProperty;

public abstract class AbstractCompositeExtractor<T, E>
extends AbstractExtractor<T, E>
implements ExternalizableLite,
PortableObject {
    private static final ValueExtractor[] EMPTY_EXTRACTOR_ARRAY = new ValueExtractor[0];
    @JsonbProperty(value="extractors")
    protected ValueExtractor[] m_aExtractor;

    public AbstractCompositeExtractor() {
    }

    public AbstractCompositeExtractor(ValueExtractor[] aExtractor) {
        AbstractCompositeExtractor.azzert(aExtractor != null);
        this.m_aExtractor = aExtractor;
    }

    public ValueExtractor[] getExtractors() {
        return this.m_aExtractor;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (this.isCanonicallyEquatable(o)) {
            return false;
        }
        if (o instanceof AbstractCompositeExtractor) {
            AbstractCompositeExtractor that = (AbstractCompositeExtractor)o;
            return Base.equals(this.getClass(), that.getClass()) && Base.equalsDeep(this.m_aExtractor, that.m_aExtractor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        String sCName = this.getCanonicalName();
        if (sCName == null) {
            int iHash = 0;
            ValueExtractor[] aExtractor = this.m_aExtractor;
            int c = aExtractor.length;
            for (int i = 0; i < c; ++i) {
                iHash += aExtractor[i].hashCode();
            }
            return iHash;
        }
        return sCName.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassHelper.getSimpleName(this.getClass())).append('(');
        ValueExtractor[] aExtractor = this.m_aExtractor;
        int c = aExtractor.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aExtractor[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int cExtractors = AbstractCompositeExtractor.readInt(in);
        ValueExtractor[] aExtractor = new ValueExtractor[cExtractors];
        for (int i = 0; i < cExtractors; ++i) {
            aExtractor[i] = (ValueExtractor)AbstractCompositeExtractor.readObject(in);
        }
        this.m_aExtractor = aExtractor;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ValueExtractor[] aExtractor = this.m_aExtractor;
        int cExtractors = aExtractor.length;
        AbstractCompositeExtractor.writeInt(out, cExtractors);
        for (int i = 0; i < cExtractors; ++i) {
            AbstractCompositeExtractor.writeObject(out, aExtractor[i]);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_aExtractor = (ValueExtractor[])in.readObjectArray(0, EMPTY_EXTRACTOR_ARRAY);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aExtractor);
    }
}

