/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.filter.ArrayFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class AllFilter
extends ArrayFilter {
    public AllFilter() {
    }

    public AllFilter(Filter[] afilter) {
        super(afilter);
    }

    @Override
    public boolean evaluate(Object o) {
        Filter[] afilter = this.m_aFilter;
        int c = afilter.length;
        for (int i = 0; i < c; ++i) {
            if (afilter[i].evaluate(o)) continue;
            return false;
        }
        return true;
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        this.optimizeFilterOrder(mapIndexes, setKeys);
        Filter[] aFilter = this.m_aFilter;
        int cFilters = aFilter.length;
        if (cFilters > 0) {
            Filter filter0 = aFilter[0];
            return filter0 instanceof IndexAwareFilter ? ((IndexAwareFilter)filter0).calculateEffectiveness(mapIndexes, setKeys) : setKeys.size() * ExtractorFilter.EVAL_COST;
        }
        return 1;
    }

    @Override
    protected boolean evaluateEntry(Map.Entry entry, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        for (Filter filter : this.m_aFilter) {
            if (this.evaluateFilter(filter, entry, ctx, step == null ? null : step.ensureStep(filter))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Filter applyIndex(Map mapIndexes, Set setKeys, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        this.optimizeFilterOrder(mapIndexes, setKeys);
        Filter[] aFilter = this.m_aFilter;
        int cFilters = aFilter.length;
        ArrayList<Filter> listFilter = new ArrayList<Filter>(cFilters);
        for (int i = 0; i < cFilters; ++i) {
            Filter filter = aFilter[i];
            if (filter instanceof IndexAwareFilter) {
                Filter filterNew = this.applyFilter(filter, i, mapIndexes, setKeys, ctx, step);
                if (setKeys.isEmpty()) {
                    return null;
                }
                if (filterNew == null) continue;
                listFilter.add(filterNew);
                continue;
            }
            listFilter.add(filter);
        }
        cFilters = listFilter.size();
        if (cFilters == 0) {
            return null;
        }
        if (cFilters == 1) {
            return (Filter)listFilter.get(0);
        }
        return new AllFilter(listFilter.toArray(new Filter[cFilters]));
    }
}

