/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.SubSet;
import com.tangosol.util.filter.AbstractQueryRecorderFilter;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.KeyFilter;
import com.tangosol.util.filter.OrFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbProperty;

public class NotFilter<T>
extends AbstractQueryRecorderFilter<T>
implements EntryFilter<Object, T>,
IndexAwareFilter<Object, T>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="filter")
    private Filter<T> m_filter;

    public NotFilter() {
    }

    public NotFilter(Filter<T> filter) {
        this.m_filter = filter;
    }

    @Override
    public boolean evaluate(T o) {
        return !this.m_filter.evaluate(o);
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        return !InvocableMapHelper.evaluateEntry(this.m_filter, entry);
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        Filter<T> filter = this.m_filter;
        return filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys) : setKeys.size() * ExtractorFilter.EVAL_COST;
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Filter<T> filter = this.m_filter;
        if (filter instanceof IndexAwareFilter) {
            SubSet setDelta = new SubSet(setKeys);
            Filter filterNew = ((IndexAwareFilter)filter).applyIndex(this.getNonPartialIndexes(mapIndexes), setDelta);
            Set setRemoved = setDelta.getRemoved();
            if (filterNew == null || setDelta.isEmpty()) {
                if (setRemoved.isEmpty()) {
                    setKeys.clear();
                } else if (!setDelta.isEmpty()) {
                    setKeys.retainAll(setRemoved);
                }
                return null;
            }
            if (setRemoved.isEmpty()) {
                return filterNew == filter ? this : new NotFilter(filterNew);
            }
            KeyFilter filterKey = new KeyFilter(setRemoved);
            NotFilter<Object> filterNot = filterNew == filter ? this : new NotFilter(filterNew);
            return new OrFilter(filterKey, filterNot);
        }
        return this;
    }

    protected Map getNonPartialIndexes(Map mapIndexes) {
        HashMap mapNonPartialIndexes = new HashMap();
        for (Map.Entry entry : mapIndexes.entrySet()) {
            if (((MapIndex)entry.getValue()).isPartial()) continue;
            mapNonPartialIndexes.put(entry.getKey(), entry.getValue());
        }
        return mapNonPartialIndexes;
    }

    public Filter<T> getFilter() {
        return this.m_filter;
    }

    public boolean equals(Object o) {
        if (o instanceof NotFilter) {
            NotFilter that = (NotFilter)o;
            return NotFilter.equals(this.m_filter, that.m_filter);
        }
        return false;
    }

    public int hashCode() {
        return NotFilter.hashCode(this.m_filter);
    }

    public String toString() {
        return "NotFilter: !(" + this.m_filter + ')';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)NotFilter.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        NotFilter.writeObject(out, this.m_filter);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
    }
}

