/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.fsm;

import com.tangosol.util.fsm.Event;
import com.tangosol.util.fsm.ExecutionContext;
import com.tangosol.util.fsm.Instruction;
import com.tangosol.util.fsm.Model;
import com.tangosol.util.fsm.ReflectionHelper;
import com.tangosol.util.fsm.RollbackTransitionException;
import com.tangosol.util.fsm.SimpleModel;
import com.tangosol.util.fsm.StateEntryAction;
import com.tangosol.util.fsm.StateExitAction;
import com.tangosol.util.fsm.Transition;
import com.tangosol.util.fsm.TransitionAction;
import com.tangosol.util.fsm.annotations.OnEnterState;
import com.tangosol.util.fsm.annotations.OnExitState;
import com.tangosol.util.fsm.annotations.OnTransition;
import com.tangosol.util.fsm.annotations.Transitions;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;

public class AnnotationDrivenModel<S extends Enum<S>>
implements Model<S> {
    private SimpleModel<S> m_model;

    public AnnotationDrivenModel(Class<S> clzState, Object oInstance) {
        TransitionActionMethod action;
        if (oInstance == null) {
            throw new IllegalArgumentException(String.format("Can't create an %s from a null instance", this.getClass().getName()));
        }
        Class<?> clzInstance = oInstance.getClass();
        this.m_model = new SimpleModel<S>(clzState);
        EnumMap mapTransitionNames = new EnumMap(clzState);
        EnumMap mapTransitionActions = new EnumMap(clzState);
        for (Enum state : this.m_model.getStates()) {
            mapTransitionNames.put(state, new EnumMap(clzState));
            mapTransitionActions.put(state, new EnumMap(clzState));
        }
        Transitions annTransitions = clzInstance.getAnnotation(Transitions.class);
        if (annTransitions != null) {
            for (com.tangosol.util.fsm.annotations.Transition annTransition : annTransitions.value()) {
                String sProvidedTransitionName = annTransition.name();
                sProvidedTransitionName = sProvidedTransitionName == null || sProvidedTransitionName.trim().isEmpty() ? null : sProvidedTransitionName;
                String sStateToName = annTransition.toState();
                S stateTo = this.m_model.getState(sStateToName);
                if (stateTo == null) {
                    throw new IllegalArgumentException(String.format("The %s defined on %s declares a to state %s that is not defined by %s.", annTransition, clzInstance, sStateToName, clzState));
                }
                for (String sStateFromName : annTransition.fromStates()) {
                    S stateFrom = this.m_model.getState(sStateFromName);
                    if (stateFrom == null) {
                        throw new IllegalArgumentException(String.format("The %s defined on %s declares a from state %s that is not defined by %s.", annTransition, clzInstance, sStateFromName, clzState));
                    }
                    String sTransitionName = sProvidedTransitionName == null ? String.format("%s to %s", ((Enum)stateFrom).name(), ((Enum)stateTo).name()) : sProvidedTransitionName;
                    ((EnumMap)mapTransitionNames.get(stateFrom)).put(stateTo, sTransitionName);
                }
            }
        }
        for (Method method : clzInstance.getMethods()) {
            OnTransition annOnTransition;
            OnExitState annOnExitState;
            OnEnterState annOnEnterState = method.getAnnotation(OnEnterState.class);
            if (annOnEnterState != null) {
                S state = this.m_model.getState(annOnEnterState.value());
                if (state == null) {
                    throw new IllegalArgumentException(String.format("The %s annotation on method %s defined in %s declares the state %s that is not defined in %s.", annOnEnterState, method, clzInstance, annOnEnterState.value(), clzState));
                }
                if (ReflectionHelper.isCompatibleMethod(method, 1, Instruction.class, new Type[]{clzState, clzState, Event.class, ExecutionContext.class})) {
                    this.m_model.addStateEntryAction(state, new StateEntryActionMethod(oInstance, method));
                } else {
                    throw new IllegalArgumentException(String.format("The method %s defined in class %s annotated with %s is not compatible with the  required method signature 'Instruction method(State, State, Context<State>);'.", method, clzInstance, annOnEnterState));
                }
            }
            if ((annOnExitState = method.getAnnotation(OnExitState.class)) != null) {
                S state = this.m_model.getState(annOnExitState.value());
                if (state == null) {
                    throw new IllegalArgumentException(String.format("The %s annotation on method %s defined in %s declares the state %s that is not defined in %s.", annOnExitState, method, clzInstance, annOnExitState.value(), clzState));
                }
                if (ReflectionHelper.isCompatibleMethod(method, 1, Void.TYPE, new Type[]{clzState, Event.class, ExecutionContext.class})) {
                    this.m_model.addStateExitAction(state, new StateExitActionMethod(oInstance, method));
                } else {
                    throw new IllegalArgumentException(String.format("The method %s defined in class %s annotated with %s is not compatible with the required method signature 'void method(State, Context<State>);'.", method, clzInstance, annOnExitState));
                }
            }
            if ((annOnTransition = method.getAnnotation(OnTransition.class)) == null) continue;
            if (ReflectionHelper.isCompatibleMethod(method, 1, Void.TYPE, new Type[]{String.class, clzState, clzState, Event.class, ExecutionContext.class})) {
                action = new TransitionActionMethod(oInstance, method);
                for (String sStateFromName : annOnTransition.fromStates()) {
                    S stateFrom = this.m_model.getState(sStateFromName);
                    if (stateFrom == null) {
                        throw new IllegalArgumentException(String.format("The %s defined on method %s in %s declares a from state %s that is not defined by %s.", annOnTransition, method, clzInstance, sStateFromName, clzState));
                    }
                    for (String sStateToName : annOnTransition.toStates()) {
                        S stateTo = this.m_model.getState(sStateToName);
                        if (stateTo == null) {
                            throw new IllegalArgumentException(String.format("The %s defined on method %s in %s declares a from state %s that is not defined by %s.", annOnTransition, method, clzInstance, sStateToName, clzState));
                        }
                        if (!((EnumMap)mapTransitionNames.get(stateFrom)).containsKey(stateTo)) {
                            throw new IllegalArgumentException(String.format("The %s defined on method %s in %s specifies a transition from  %s to %s that is not defined by the Finite State Machine.", annOnTransition, method, clzInstance, stateFrom, stateTo));
                        }
                        ((EnumMap)mapTransitionActions.get(stateFrom)).put(stateTo, action);
                    }
                }
                continue;
            }
            throw new IllegalArgumentException(String.format("The method %s defined in class %s annotated with %s is not compatible with the required method signature 'void method(String, State, State,  Event<State>, Context<State>);'.", method, clzInstance, annOnTransition));
        }
        for (Enum stateFrom : this.m_model.getStates()) {
            for (Enum stateTo : mapTransitionNames.keySet()) {
                String sTransitionName = (String)((EnumMap)mapTransitionNames.get(stateFrom)).get(stateTo);
                if (sTransitionName == null) continue;
                action = (TransitionActionMethod)((EnumMap)mapTransitionActions.get(stateFrom)).get(stateTo);
                this.m_model.addTransition(new Transition<Enum>(sTransitionName, stateFrom, stateTo, action));
            }
        }
    }

    @Override
    public Class<S> getStateClass() {
        return this.m_model.getStateClass();
    }

    @Override
    public Map<S, StateEntryAction<S>> getStateEntryActions() {
        return this.m_model.getStateEntryActions();
    }

    @Override
    public Map<S, StateExitAction<S>> getStateExitActions() {
        return this.m_model.getStateExitActions();
    }

    @Override
    public S[] getStates() {
        return this.m_model.getStates();
    }

    @Override
    public Iterable<Transition<S>> getTransitions() {
        return this.m_model.getTransitions();
    }

    private static class TransitionActionMethod<S extends Enum<S>>
    implements TransitionAction<S> {
        private Object m_oInstance;
        private Method m_method;

        public TransitionActionMethod(Object oInstance, Method method) {
            this.m_oInstance = oInstance;
            this.m_method = method;
        }

        @Override
        public void onTransition(String sTransitionName, S stateFrom, S stateTo, Event<S> event, ExecutionContext context) throws RollbackTransitionException {
            try {
                this.m_method.invoke(this.m_oInstance, sTransitionName, stateFrom, stateTo, event, context);
            }
            catch (Exception e) {
                throw new RollbackTransitionException((Enum<?>)stateFrom, (Enum<?>)stateTo, e);
            }
        }
    }

    private static class StateExitActionMethod<S extends Enum<S>>
    implements StateExitAction<S> {
        private Object m_oInstance;
        private Method m_method;

        public StateExitActionMethod(Object oInstance, Method method) {
            this.m_oInstance = oInstance;
            this.m_method = method;
        }

        @Override
        public void onExitState(S state, Event<S> event, ExecutionContext context) {
            try {
                this.m_method.invoke(this.m_oInstance, state, event, context);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class StateEntryActionMethod<S extends Enum<S>>
    implements StateEntryAction<S> {
        private Object m_oInstance;
        private Method m_method;

        public StateEntryActionMethod(Object oInstance, Method method) {
            this.m_oInstance = oInstance;
            this.m_method = method;
        }

        @Override
        public Instruction onEnterState(S previousState, S newState, Event<S> event, ExecutionContext context) {
            try {
                return (Instruction)this.m_method.invoke(this.m_oInstance, previousState, newState, event, context);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

